/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.api;

import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.services.exceptions.BusinessException;

@Path(value="runtime")
public interface RuntimeProvisioningService {
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="providertypes")
    public ProviderTypeList getProviderTypes(@QueryParam(value="page") @DefaultValue(value="0") Integer var1, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer var2, @QueryParam(value="sort") String var3, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean var4) throws BusinessException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="providers")
    public ProviderList getProviders(@QueryParam(value="page") @DefaultValue(value="0") Integer var1, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer var2, @QueryParam(value="sort") String var3, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean var4) throws BusinessException;

    @POST
    @Consumes(value={"application/json"})
    @Path(value="providers")
    public void registerProvider(@NotNull ProviderConfig var1) throws BusinessException;

    @DELETE
    @Path(value="providers")
    public void unregisterProvider(@FormParam(value="name") String var1) throws BusinessException;

    @POST
    @Path(value="runtimes/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String newRuntime(@NotNull RuntimeConfig var1) throws BusinessException;

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="runtimes/{id}")
    public void destroyRuntime(@PathParam(value="id") String var1) throws BusinessException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="runtimes/")
    public RuntimeList getRuntimes(@QueryParam(value="page") @DefaultValue(value="0") Integer var1, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer var2, @QueryParam(value="sort") String var3, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean var4) throws BusinessException;

    @POST
    @Path(value="runtimes/{id}/state")
    public void startRuntime(@PathParam(value="id") String var1) throws BusinessException;

    @DELETE
    @Path(value="runtimes/{id}/state")
    public void stopRuntime(@PathParam(value="id") String var1) throws BusinessException;

    @PUT
    @Path(value="runtimes/{id}/state")
    public void restartRuntime(@PathParam(value="id") String var1) throws BusinessException;
}

