/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.services.exceptions.BusinessException;
import org.guvnor.ala.services.rest.factories.ProviderFactory;
import org.guvnor.ala.services.rest.factories.RuntimeFactory;
import org.guvnor.ala.services.rest.factories.RuntimeManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RestRuntimeProvisioningServiceImpl
implements RuntimeProvisioningService {
    protected static final Logger LOG = LoggerFactory.getLogger(RestRuntimeProvisioningServiceImpl.class);
    @Inject
    private RuntimeRegistry registry;
    @Inject
    private BeanManager beanManager;
    @Inject
    private ProviderFactory providerFactory;
    @Inject
    private RuntimeFactory runtimeFactory;
    @Inject
    private RuntimeManagerFactory runtimeManagerFactory;

    @PostConstruct
    public void cacheBeans() {
        LOG.info("> Initializing ProviderTypes. ");
        Set beans = this.beanManager.getBeans(ProviderType.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        for (Bean b : beans) {
            try {
                ProviderType pt = (ProviderType)b.getBeanClass().newInstance();
                LOG.info("> Registering ProviderType: " + pt.getProviderTypeName());
                this.registry.registerProviderType(pt);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOG.error("Something went wrong with registering Provider Types!", (Throwable)ex);
            }
        }
    }

    public ProviderTypeList getProviderTypes(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return new ProviderTypeList(this.registry.getProviderTypes(page, pageSize, sort, sortOrder));
    }

    public ProviderList getProviders(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return new ProviderList(this.registry.getProviders(page, pageSize, sort, sortOrder));
    }

    public RuntimeList getRuntimes(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return new RuntimeList(this.registry.getRuntimes(page, pageSize, sort, sortOrder));
    }

    public void registerProvider(ProviderConfig conf) throws BusinessException {
        Optional<Provider> newProvider = this.providerFactory.newProvider(conf);
        if (newProvider.isPresent()) {
            this.registry.registerProvider(newProvider.get());
        }
    }

    public void unregisterProvider(String name) throws BusinessException {
        this.registry.unregisterProvider(name);
    }

    public String newRuntime(RuntimeConfig conf) throws BusinessException {
        Optional<Runtime> newRuntime = this.runtimeFactory.newRuntime(conf);
        if (newRuntime.isPresent()) {
            return newRuntime.get().getId();
        }
        return null;
    }

    public void destroyRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.registry.getRuntimeById(runtimeId);
        this.runtimeFactory.destroyRuntime((RuntimeId)runtimeById);
    }

    public void startRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.registry.getRuntimeById(runtimeId);
        this.runtimeManagerFactory.startRuntime((RuntimeId)runtimeById);
    }

    public void stopRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.registry.getRuntimeById(runtimeId);
        this.runtimeManagerFactory.stopRuntime((RuntimeId)runtimeById);
    }

    public void restartRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.registry.getRuntimeById(runtimeId);
        this.runtimeManagerFactory.restartRuntime((RuntimeId)runtimeById);
    }
}

