/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.ala.config;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.guvnor.ala.runtime.providers.ProviderId;

/**
 * Base Provisioning Config interface. Provide different implementations for
 * supporting different provisioning mechanisms configurations.
 */
@JsonTypeInfo( use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.WRAPPER_OBJECT )
public interface ProvisioningConfig extends Config {

    /*
     * Get the provider Id used by this configuration
     * @return the ProviderId
     * @see ProviderId
     */
    ProviderId getProviderId();

}
