/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.registry.PipelineRegistry;
import org.guvnor.ala.registry.inmemory.util.PageSortUtil;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class InMemoryPipelineRegistry
implements PipelineRegistry {
    protected Map<String, PipelineRegistryEntry> pipelineByName = new ConcurrentHashMap<String, PipelineRegistryEntry>();

    @Override
    public void registerPipeline(Pipeline pipeline) {
        PortablePreconditions.checkNotNull((String)"pipeline", (Object)pipeline);
        this.pipelineByName.put(pipeline.getName(), new PipelineRegistryEntry(pipeline));
    }

    @Override
    public void registerPipeline(Pipeline pipeline, ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"pipeline", (Object)pipeline);
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        this.pipelineByName.put(pipeline.getName(), new PipelineRegistryEntry(pipeline, providerType));
    }

    @Override
    public Pipeline getPipelineByName(String pipelineId) {
        PortablePreconditions.checkNotNull((String)"pipelineId", (Object)pipelineId);
        return this.pipelineByName.get(pipelineId).getPipeline();
    }

    @Override
    public List<Pipeline> getPipelines(int page, int pageSize, String sort, boolean sortOrder) {
        List<Pipeline> values = this.pipelineByName.values().stream().map(PipelineRegistryEntry::getPipeline).collect(Collectors.toList());
        return this.sortPagedResult(values, page, pageSize, sort, sortOrder);
    }

    @Override
    public List<Pipeline> getPipelines(String providerType, String version, int page, int pageSize, String sort, boolean sortOrder) {
        ProviderTypeFilter filter = ProviderTypeFilter.newInstance().withProviderTypeName(providerType).withVersion(version);
        List<Pipeline> values = this.pipelineByName.values().stream().filter(entry -> filter.test(entry.getProviderType())).map(PipelineRegistryEntry::getPipeline).collect(Collectors.toList());
        return this.sortPagedResult(values, page, pageSize, sort, sortOrder);
    }

    @Override
    public ProviderType getProviderType(String pipelineId) {
        PortablePreconditions.checkNotNull((String)"pipelineId", (Object)pipelineId);
        PipelineRegistryEntry entry = this.pipelineByName.get(pipelineId);
        return entry != null ? entry.getProviderType() : null;
    }

    private List<Pipeline> sortPagedResult(List<Pipeline> values, int page, int pageSize, String sort, boolean sortOrder) {
        return PageSortUtil.pageSort(values, (p1, p2) -> {
            switch (sort) {
                case "name": {
                    return p1.getName().compareTo(p2.getName());
                }
            }
            return p1.toString().compareTo(p2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    static class ProviderTypeFilter
    implements Predicate<ProviderType> {
        private String providerTypeName;
        private String version;

        private ProviderTypeFilter() {
        }

        public static ProviderTypeFilter newInstance() {
            return new ProviderTypeFilter();
        }

        public ProviderTypeFilter withProviderTypeName(String providerTypeName) {
            this.providerTypeName = providerTypeName;
            return this;
        }

        public ProviderTypeFilter withVersion(String version) {
            this.version = version;
            return this;
        }

        @Override
        public boolean test(ProviderType providerType) {
            return this.providerTypeName != null && providerType != null && this.providerTypeName.equals(providerType.getProviderTypeName()) && this.version != null && this.version.equals(providerType.getVersion());
        }
    }

    private static class PipelineRegistryEntry {
        private Pipeline pipeline;
        private ProviderType providerType;

        public PipelineRegistryEntry(Pipeline pipeline) {
            this.pipeline = pipeline;
        }

        public PipelineRegistryEntry(Pipeline pipeline, ProviderType providerType) {
            this.pipeline = pipeline;
            this.providerType = providerType;
        }

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public ProviderType getProviderType() {
            return this.providerType;
        }
    }
}

