/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.empty.ProviderTypeEmptyPresenter;
import org.guvnor.ala.ui.client.events.ProviderSelectedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeDeletedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.navigation.ProviderTypeNavigationPresenter;
import org.guvnor.ala.ui.client.navigation.providertype.ProviderTypePresenter;
import org.guvnor.ala.ui.client.provider.ProviderPresenter;
import org.guvnor.ala.ui.client.provider.empty.ProviderEmptyPresenter;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.lifecycle.OnOpen;

@ApplicationScoped
@WorkbenchScreen(identifier="ProvisioningManagementBrowser")
public class ProvisioningManagementBrowserPresenter {
    public static final String IDENTIFIER = "ProvisioningManagementBrowser";
    private final View view;
    private final ProviderTypeNavigationPresenter providerTypeNavigationPresenter;
    private final ProviderTypePresenter providerTypePresenter;
    private final ProviderTypeEmptyPresenter providerTypeEmptyPresenter;
    private final ProviderEmptyPresenter providerEmptyPresenter;
    private final ProviderPresenter providerPresenter;
    private final Caller<ProviderTypeService> providerTypeService;
    private final Caller<ProviderService> providerService;
    private final Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent;

    @Inject
    public ProvisioningManagementBrowserPresenter(View view, ProviderTypeNavigationPresenter providerTypeNavigationPresenter, ProviderTypePresenter providerTypePresenter, ProviderTypeEmptyPresenter providerTypeEmptyPresenter, ProviderEmptyPresenter providerEmptyPresenter, ProviderPresenter providerPresenter, Caller<ProviderTypeService> providerTypeService, Caller<ProviderService> providerService, Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent) {
        this.view = view;
        this.providerTypeNavigationPresenter = providerTypeNavigationPresenter;
        this.providerTypePresenter = providerTypePresenter;
        this.providerTypeEmptyPresenter = providerTypeEmptyPresenter;
        this.providerEmptyPresenter = providerEmptyPresenter;
        this.providerPresenter = providerPresenter;
        this.providerTypeService = providerTypeService;
        this.providerService = providerService;
        this.providerTypeSelectedEvent = providerTypeSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setProviderTypesNavigation(this.providerTypeNavigationPresenter.getView());
    }

    @OnOpen
    public void onOpen() {
        this.refreshProviderTypes();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.view.getTitle();
    }

    @WorkbenchPartView
    public IsElement getView() {
        return this.view;
    }

    protected void onRefreshProviderTypes(@Observes ProviderTypeListRefreshEvent event) {
        this.refreshProviderTypes(event.getProviderTypeKey());
    }

    protected void onProviderTypeSelected(@Observes ProviderTypeSelectedEvent event) {
        if (event.getProviderTypeKey() != null) {
            this.selectProviderType(event.getProviderTypeKey(), event.getProviderId());
        }
    }

    protected void onProviderTypeDeleted(@Observes ProviderTypeDeletedEvent event) {
        this.refreshProviderTypes();
    }

    protected void onProviderSelected(@Observes ProviderSelectedEvent event) {
        if (event.getProviderKey() != null) {
            this.view.setContent(this.providerPresenter.getView());
        }
    }

    private void refreshProviderTypes() {
        this.refreshProviderTypes(null);
    }

    private void refreshProviderTypes(ProviderTypeKey selectProviderTypeKey) {
        ((ProviderTypeService)this.providerTypeService.call(providerTypes -> this.setupProviderTypes((Collection<ProviderType>)providerTypes, selectProviderTypeKey), (ErrorCallback)new DefaultErrorCallback())).getEnabledProviderTypes();
    }

    private void selectProviderType(ProviderTypeKey providerTypeKey, String selectedProviderId) {
        ((ProviderService)this.providerService.call(providersInfo -> this.setupProviderType(providersInfo.getProviderType(), providersInfo.getProvidersKey(), selectedProviderId), (ErrorCallback)new DefaultErrorCallback())).getProvidersInfo(providerTypeKey);
    }

    private void setupProviderTypes(Collection<ProviderType> providerTypes, ProviderTypeKey selectProviderTypeKey) {
        if (providerTypes.isEmpty()) {
            this.view.setEmptyView(this.providerTypeEmptyPresenter.getView());
            this.providerTypeNavigationPresenter.clear();
        } else {
            ProviderType providerType2BeSelected = null;
            if (selectProviderTypeKey != null) {
                for (ProviderType providerType : providerTypes) {
                    if (!((ProviderTypeKey)providerType.getKey()).equals((Object)selectProviderTypeKey)) continue;
                    providerType2BeSelected = providerType;
                    break;
                }
            }
            if (providerType2BeSelected == null) {
                providerType2BeSelected = providerTypes.iterator().next();
            }
            this.providerTypeNavigationPresenter.setup(providerType2BeSelected, providerTypes);
            this.providerTypeSelectedEvent.fire((Object)new ProviderTypeSelectedEvent((ProviderTypeKey)providerType2BeSelected.getKey()));
        }
    }

    private void setupProviderType(ProviderType providerType, Collection<ProviderKey> providerKeys, String selectProviderId) {
        ProviderKey provider2BeSelected = null;
        this.view.setProviderType(this.providerTypePresenter.getView());
        if (providerKeys.isEmpty()) {
            this.providerEmptyPresenter.setProviderType(providerType);
            this.view.setContent(this.providerEmptyPresenter.getView());
        } else {
            if (selectProviderId != null) {
                for (ProviderKey provider : providerKeys) {
                    if (!provider.getId().equals(selectProviderId)) continue;
                    provider2BeSelected = provider;
                    break;
                }
            }
            if (provider2BeSelected == null) {
                provider2BeSelected = providerKeys.iterator().next();
            }
        }
        this.providerTypePresenter.setup(providerType, providerKeys, provider2BeSelected);
    }

    public static interface View
    extends UberElement<ProvisioningManagementBrowserPresenter> {
        public String getTitle();

        public void setProviderTypesNavigation(ProviderTypeNavigationPresenter.View var1);

        public void setProviderType(ProviderTypePresenter.View var1);

        public void setEmptyView(ProviderTypeEmptyPresenter.View var1);

        public void setContent(IsElement var1);
    }
}

