/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.navigation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.AddNewProviderTypeEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class ProviderTypeNavigationPresenter {
    private final View view;
    private final Event<AddNewProviderTypeEvent> addNewProviderTypeEvent;
    private final Event<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent;
    private final Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    private Map<ProviderTypeKey, ProviderType> providerTypes = new HashMap<ProviderTypeKey, ProviderType>();

    @Inject
    public ProviderTypeNavigationPresenter(View view, Event<AddNewProviderTypeEvent> addNewProviderTypeEvent, Event<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent, Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent) {
        this.view = view;
        this.addNewProviderTypeEvent = addNewProviderTypeEvent;
        this.providerTypeListRefreshEvent = providerTypeListRefreshEvent;
        this.providerTypeSelectedEvent = providerTypeSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(ProviderType firstProvider, Collection<ProviderType> providerTypes) {
        this.view.clear();
        this.providerTypes.clear();
        this.addProviderType((ProviderType)PortablePreconditions.checkNotNull((String)"firstProvider", (Object)firstProvider));
        providerTypes.stream().filter(providerType -> !providerType.equals((Object)firstProvider)).forEach(this::addProviderType);
    }

    public View getView() {
        return this.view;
    }

    private void addProviderType(ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        this.providerTypes.put((ProviderTypeKey)providerType.getKey(), providerType);
        this.view.addProviderType((ProviderTypeKey)providerType.getKey(), UIUtil.getDisplayableProviderTypeName(providerType), () -> this.select(providerType));
    }

    protected void onSelect(@Observes ProviderTypeSelectedEvent event) {
        if (event.getProviderTypeKey() != null && this.providerTypes.containsKey(event.getProviderTypeKey())) {
            this.view.select(event.getProviderTypeKey());
        }
    }

    private void select(ProviderType providerType) {
        this.providerTypeSelectedEvent.fire((Object)new ProviderTypeSelectedEvent((ProviderTypeKey)providerType.getKey()));
    }

    public void clear() {
        this.view.clear();
    }

    public void onRefresh() {
        this.providerTypeListRefreshEvent.fire((Object)new ProviderTypeListRefreshEvent());
    }

    public void onAddProviderType() {
        this.addNewProviderTypeEvent.fire((Object)new AddNewProviderTypeEvent());
    }

    public static interface View
    extends UberElement<ProviderTypeNavigationPresenter> {
        public void addProviderType(ProviderTypeKey var1, String var2, Command var3);

        public void select(ProviderTypeKey var1);

        public void clear();
    }
}

