/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.AddNewRuntimeEvent;
import org.guvnor.ala.ui.client.events.ProviderSelectedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.events.RefreshRuntimeEvent;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.provider.status.ProviderStatusPresenter;
import org.guvnor.ala.ui.client.provider.status.empty.ProviderStatusEmptyPresenter;
import org.guvnor.ala.ui.client.wizard.provider.empty.ProviderConfigEmptyPresenter;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.RuntimesInfo;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class ProviderPresenter {
    private final View view;
    private final Caller<ProviderService> providerService;
    private final Caller<RuntimeService> runtimeService;
    private final ProviderStatusEmptyPresenter providerStatusEmptyPresenter;
    private final ProviderStatusPresenter providerStatusPresenter;
    private final ProviderConfigEmptyPresenter providerConfigEmptyPresenter;
    private final ClientProviderHandlerRegistry providerHandlerRegistry;
    private final Event<NotificationEvent> notification;
    private final Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    private final Event<AddNewRuntimeEvent> addNewRuntimeEvent;
    private Provider provider;
    private Map<ProviderConfigurationForm, FormResolver> formToResolverMap = new HashMap<ProviderConfigurationForm, FormResolver>();

    @Inject
    public ProviderPresenter(View view, Caller<ProviderService> providerService, Caller<RuntimeService> runtimeService, ProviderStatusEmptyPresenter providerStatusEmptyPresenter, ProviderStatusPresenter providerStatusPresenter, ProviderConfigEmptyPresenter providerConfigEmptyPresenter, ClientProviderHandlerRegistry providerHandlerRegistry, Event<NotificationEvent> notification, Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent, Event<AddNewRuntimeEvent> addNewRuntimeEvent) {
        this.view = view;
        this.providerService = providerService;
        this.runtimeService = runtimeService;
        this.providerStatusEmptyPresenter = providerStatusEmptyPresenter;
        this.providerStatusPresenter = providerStatusPresenter;
        this.providerConfigEmptyPresenter = providerConfigEmptyPresenter;
        this.providerHandlerRegistry = providerHandlerRegistry;
        this.notification = notification;
        this.providerTypeSelectedEvent = providerTypeSelectedEvent;
        this.addNewRuntimeEvent = addNewRuntimeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void onProviderSelected(@Observes ProviderSelectedEvent event) {
        if (event.getProviderKey() != null) {
            this.load(event.getProviderKey());
        }
    }

    public void onRefreshRuntime(@Observes RefreshRuntimeEvent event) {
        if (event.getProviderKey() != null && event.getProviderKey().equals(this.provider.getKey())) {
            this.load(event.getProviderKey());
        }
    }

    private void load(ProviderKey providerKey) {
        this.providerStatusPresenter.clear();
        ((RuntimeService)this.runtimeService.call(this.getLoadRuntimesInfoSuccessCallback(), (ErrorCallback)new DefaultErrorCallback())).getRuntimesInfo(providerKey);
    }

    private RemoteCallback<RuntimesInfo> getLoadRuntimesInfoSuccessCallback() {
        return info -> {
            this.provider = info.getProvider();
            this.clearProviderConfigurationForm();
            this.view.setProviderName(((ProviderKey)this.provider.getKey()).getId());
            if (info.getRuntimeItems().isEmpty()) {
                this.providerStatusEmptyPresenter.setup((ProviderKey)this.provider.getKey());
                this.view.setStatus((IsElement)this.providerStatusEmptyPresenter.getView());
            } else {
                this.providerStatusPresenter.setupItems(info.getRuntimeItems());
                this.view.setStatus((IsElement)this.providerStatusPresenter.getView());
            }
            ProviderConfigurationForm providerConfigurationForm = this.newProviderConfigurationForm(((ProviderKey)this.provider.getKey()).getProviderTypeKey());
            providerConfigurationForm.load(this.provider);
            providerConfigurationForm.disable();
            this.view.setConfig(providerConfigurationForm.getView());
        };
    }

    public void refresh() {
        this.load((ProviderKey)this.provider.getKey());
    }

    public void onRemoveProvider() {
        this.view.confirmRemove(this::removeProvider);
    }

    public void removeProvider() {
        ((ProviderService)this.providerService.call(response -> {
            this.notification.fire((Object)new NotificationEvent(this.view.getRemoveProviderSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            this.providerTypeSelectedEvent.fire((Object)new ProviderTypeSelectedEvent(((ProviderKey)this.provider.getKey()).getProviderTypeKey()));
        }, (message, throwable) -> {
            this.notification.fire((Object)new NotificationEvent(this.view.getRemoveProviderErrorMessage(), NotificationEvent.NotificationType.ERROR));
            this.providerTypeSelectedEvent.fire((Object)new ProviderTypeSelectedEvent(((ProviderKey)this.provider.getKey()).getProviderTypeKey()));
            return false;
        })).deleteProvider((ProviderKey)this.provider.getKey());
    }

    public void deploy() {
        this.addNewRuntimeEvent.fire((Object)new AddNewRuntimeEvent(this.provider));
    }

    public IsElement getView() {
        return this.view;
    }

    private ProviderConfigurationForm newProviderConfigurationForm(ProviderTypeKey providerTypeKey) {
        if (this.providerHandlerRegistry.isProviderEnabled(providerTypeKey)) {
            FormResolver formResolver = ((ClientProviderHandler)this.providerHandlerRegistry.getProviderHandler(providerTypeKey)).getFormResolver();
            Object providerConfigurationForm = formResolver.newProviderConfigurationForm();
            this.formToResolverMap.put((ProviderConfigurationForm)providerConfigurationForm, formResolver);
            return providerConfigurationForm;
        }
        return this.providerConfigEmptyPresenter;
    }

    private void clearProviderConfigurationForm() {
        this.formToResolverMap.entrySet().forEach(entry -> ((FormResolver)entry.getValue()).destroyForm((ProviderConfigurationForm)entry.getKey()));
        this.formToResolverMap.clear();
    }

    public static interface View
    extends UberElement<ProviderPresenter> {
        public void confirmRemove(Command var1);

        public void setProviderName(String var1);

        public void setStatus(IsElement var1);

        public void setConfig(IsElement var1);

        public String getRemoveProviderSuccessMessage();

        public String getRemoveProviderErrorMessage();
    }
}

