/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterHelper;
import org.guvnor.ala.ui.client.widget.pipeline.PipelinePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.StagePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.State;
import org.guvnor.ala.ui.client.widget.pipeline.transition.TransitionPresenter;
import org.guvnor.ala.ui.events.PipelineStatusChangeEvent;
import org.guvnor.ala.ui.events.StageStatusChangeEvent;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.Stage;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@Dependent
public class RuntimePresenter {
    private static final String SYSTEM_PIPELINE_NAME = "<system>";
    private final View view;
    private final PipelinePresenter pipelinePresenter;
    private final ManagedInstance<StagePresenter> stagePresenterInstance;
    private final ManagedInstance<TransitionPresenter> transitionPresenterInstance;
    private final Caller<RuntimeService> runtimeService;
    private final List<Stage> currentStages = new ArrayList<Stage>();
    private final Map<Stage, StagePresenter> stagePresenters = new HashMap<Stage, StagePresenter>();
    private final List<TransitionPresenter> currentTransitions = new ArrayList<TransitionPresenter>();
    private RuntimeListItem item;

    @Inject
    public RuntimePresenter(View view, PipelinePresenter pipelinePresenter, ManagedInstance<StagePresenter> stagePresenterInstance, ManagedInstance<TransitionPresenter> transitionPresenterInstance, Caller<RuntimeService> runtimeService) {
        this.view = view;
        this.pipelinePresenter = pipelinePresenter;
        this.stagePresenterInstance = stagePresenterInstance;
        this.transitionPresenterInstance = transitionPresenterInstance;
        this.runtimeService = runtimeService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(RuntimeListItem runtimeListItem) {
        this.item = runtimeListItem;
        this.clearPipeline();
        if (this.item.isRuntime()) {
            this.setupRuntime(runtimeListItem);
        } else {
            this.setupPipelineTrace(runtimeListItem);
        }
        this.view.addExpandedContent((IsElement)this.pipelinePresenter.getView());
    }

    private void setupRuntime(RuntimeListItem item) {
        String itemLabel = item.getItemLabel();
        String pipelineName = SYSTEM_PIPELINE_NAME;
        String createdDate = item.getRuntime().createDate();
        String endpoint = "";
        Runtime runtime = item.getRuntime();
        PipelineExecutionTrace trace = runtime.getPipelineTrace();
        if (trace != null) {
            pipelineName = ((PipelineKey)trace.getPipeline().getKey()).getId();
            this.setupPipeline(trace);
        }
        this.view.setup(itemLabel, createdDate, pipelineName);
        if (runtime.getEndpoint() != null) {
            endpoint = runtime.getEndpoint();
        }
        this.view.setEndpoint(endpoint);
        if (trace != null) {
            this.processPipelineStatus(trace.getPipelineStatus());
        }
    }

    private void setupPipelineTrace(RuntimeListItem item) {
        PipelineExecutionTrace trace = item.getPipelineTrace();
        String itemLabel = item.getItemLabel();
        String pipelineName = ((PipelineKey)trace.getPipeline().getKey()).getId();
        String createdDate = "";
        this.view.setup(itemLabel, createdDate, pipelineName);
        this.setupPipeline(trace);
        this.processPipelineStatus(trace.getPipelineStatus());
    }

    private void setupPipeline(PipelineExecutionTrace trace) {
        this.clearPipeline();
        boolean showStep = true;
        Pipeline pipeline = trace.getPipeline();
        for (int i = 0; showStep && i < pipeline.getStages().size(); ++i) {
            Stage stage = (Stage)pipeline.getStages().get(i);
            PipelineStatus stageStatus = trace.getStageStatus(stage.getName());
            showStep = this.showStage(stageStatus);
            if (!showStep) continue;
            if (i > 0) {
                TransitionPresenter transitionPresenter = this.newTransitionPresenter();
                this.currentTransitions.add(transitionPresenter);
                this.pipelinePresenter.addStage(transitionPresenter.getView());
            }
            StagePresenter stagePresenter = this.newStagePresenter();
            stagePresenter.setup(stage);
            stagePresenter.setState(this.calculateState(stageStatus));
            this.pipelinePresenter.addStage((IsElement)stagePresenter.getView());
            this.currentStages.add(stage);
            this.stagePresenters.put(stage, stagePresenter);
        }
    }

    private boolean showStage(PipelineStatus stageStatus) {
        return stageStatus == PipelineStatus.RUNNING || stageStatus == PipelineStatus.FINISHED || stageStatus == PipelineStatus.ERROR;
    }

    private State calculateState(PipelineStatus stageStatus) {
        if (stageStatus == PipelineStatus.RUNNING) {
            return State.EXECUTING;
        }
        if (stageStatus == PipelineStatus.ERROR) {
            return State.ERROR;
        }
        return State.DONE;
    }

    private void processRuntimeStatus(Runtime runtime) {
        if (runtime.getStatus() != null) {
            switch (runtime.getStatus()) {
                case STARTED: 
                case LOADING: 
                case WARN: {
                    this.view.setEndpoint(runtime.getEndpoint());
                    this.view.enableStop();
                    this.view.disableStart();
                    break;
                }
                case STOPPED: 
                case ERROR: {
                    this.view.disableStop();
                    this.view.enableStart();
                }
            }
            this.view.setStatus(RuntimePresenterHelper.buildStyle(runtime.getStatus()));
        }
    }

    private void processPipelineStatus(PipelineStatus status) {
        this.view.setStatus(RuntimePresenterHelper.buildStyle(status));
    }

    public void onStageStatusChange(@Observes StageStatusChangeEvent event) {
        if (this.isFromCurrentPipeline(event.getPipelineExecutionTraceKey())) {
            PipelineExecutionTrace trace = this.item.getPipelineTrace();
            Stage currentStage = this.currentStages.stream().filter(step -> event.getStage().equals(step.getName())).findFirst().orElse(null);
            if (currentStage != null) {
                StagePresenter stagePresenter = this.stagePresenters.get(currentStage);
                stagePresenter.setState(this.calculateState(event.getStatus()));
            } else {
                Stage stage = new Stage((PipelineKey)this.item.getPipelineTrace().getPipeline().getKey(), event.getStage());
                PipelineStatus stageStatus = event.getStatus();
                StagePresenter stagePresenter = this.newStagePresenter();
                stagePresenter.setup(stage);
                stagePresenter.setState(this.calculateState(stageStatus));
                if (!this.currentStages.isEmpty()) {
                    TransitionPresenter transitionPresenter = this.newTransitionPresenter();
                    this.currentTransitions.add(transitionPresenter);
                    this.pipelinePresenter.addStage(transitionPresenter.getView());
                }
                this.pipelinePresenter.addStage((IsElement)stagePresenter.getView());
                this.currentStages.add(stage);
                this.stagePresenters.put(stage, stagePresenter);
            }
            trace.setStageStatus(event.getStage(), event.getStatus());
        }
    }

    public void onPipelineStatusChange(@Observes PipelineStatusChangeEvent event) {
        if (this.isFromCurrentPipeline(event.getPipelineExecutionTraceKey())) {
            this.processPipelineStatus(event.getStatus());
            if (PipelineStatus.FINISHED.equals((Object)event.getStatus()) && !PipelineStatus.FINISHED.equals((Object)this.item.getPipelineTrace().getPipelineStatus())) {
                this.refresh(event.getPipelineExecutionTraceKey());
            }
        }
    }

    private void refresh(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        ((RuntimeService)this.runtimeService.call(this.getLoadItemSuccessCallback(), (ErrorCallback)new DefaultErrorCallback())).getRuntimeItem(pipelineExecutionTraceKey);
    }

    private RemoteCallback<RuntimeListItem> getLoadItemSuccessCallback() {
        return runtimeListItem -> {
            if (runtimeListItem != null) {
                this.setup((RuntimeListItem)runtimeListItem);
            }
        };
    }

    public void start() {
        Window.alert((String)"Not yet implemented");
    }

    public void stop() {
        Window.alert((String)"Not yet implemented");
    }

    public void rebuild() {
        Window.alert((String)"Not yet implemented");
    }

    public void delete() {
        Window.alert((String)"Not yet implemented");
    }

    public View getView() {
        return this.view;
    }

    private boolean isFromCurrentPipeline(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        return this.item != null && !this.item.isRuntime() && ((PipelineExecutionTraceKey)this.item.getPipelineTrace().getKey()).equals((Object)pipelineExecutionTraceKey);
    }

    private void clearPipeline() {
        this.pipelinePresenter.clearStages();
        this.currentStages.clear();
        this.stagePresenters.values().forEach(arg_0 -> this.stagePresenterInstance.destroy(arg_0));
        this.currentTransitions.forEach(arg_0 -> this.transitionPresenterInstance.destroy(arg_0));
        this.currentTransitions.clear();
    }

    protected StagePresenter newStagePresenter() {
        return (StagePresenter)this.stagePresenterInstance.get();
    }

    protected TransitionPresenter newTransitionPresenter() {
        return (TransitionPresenter)this.transitionPresenterInstance.get();
    }

    public static interface View
    extends UberElement<RuntimePresenter> {
        public void setup(String var1, String var2, String var3);

        public void setEndpoint(String var1);

        public void disableStart();

        public void enableStart();

        public void disableStop();

        public void enableStop();

        public void setStatus(Collection<String> var1);

        public void addExpandedContent(IsElement var1);
    }
}

