/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.RefreshRuntimeEvent;
import org.guvnor.ala.ui.client.wizard.AbstractMultiPageWizard;
import org.guvnor.ala.ui.client.wizard.pipeline.SelectPipelinePagePresenter;
import org.guvnor.ala.ui.client.wizard.source.SourceConfigurationPagePresenter;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.Source;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class NewDeployWizard
extends AbstractMultiPageWizard {
    private final SelectPipelinePagePresenter selectPipelinePage;
    private final SourceConfigurationPagePresenter sourceConfigPage;
    private final Caller<RuntimeService> runtimeService;
    private final Event<RefreshRuntimeEvent> refreshRuntimeEvent;
    private Provider provider;

    @Inject
    public NewDeployWizard(SelectPipelinePagePresenter selectPipelinePage, SourceConfigurationPagePresenter sourceConfigPage, TranslationService translationService, Caller<RuntimeService> runtimeService, Event<NotificationEvent> notification, Event<RefreshRuntimeEvent> refreshRuntimeEvent) {
        super(translationService, notification);
        this.selectPipelinePage = selectPipelinePage;
        this.sourceConfigPage = sourceConfigPage;
        this.runtimeService = runtimeService;
        this.refreshRuntimeEvent = refreshRuntimeEvent;
    }

    @PostConstruct
    public void init() {
        this.pages.add(this.selectPipelinePage);
        this.pages.add(this.sourceConfigPage);
    }

    public void start(Provider provider, Collection<PipelineKey> pipelines) {
        this.provider = provider;
        this.clear();
        this.selectPipelinePage.setup(pipelines);
        this.sourceConfigPage.setup();
        super.start();
    }

    public String getTitle() {
        return this.translationService.getTranslation("NewDeployWizard.Title");
    }

    public int getPreferredHeight() {
        return 550;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void complete() {
        PipelineKey pipeline = this.selectPipelinePage.getPipeline();
        String runtime = this.sourceConfigPage.getRuntime();
        Source source = this.sourceConfigPage.buildSource();
        ((RuntimeService)this.runtimeService.call(aVoid -> this.onPipelineStartSuccess(), (message, throwable) -> this.onPipelineStartError())).createRuntime((ProviderKey)this.provider.getKey(), runtime, source, pipeline);
    }

    private void onPipelineStartSuccess() {
        this.notification.fire((Object)new NotificationEvent(this.translationService.getTranslation("NewDeployWizard.PipelineStartSuccessMessage"), NotificationEvent.NotificationType.SUCCESS));
        NewDeployWizard.super.complete();
        this.refreshRuntimeEvent.fire((Object)new RefreshRuntimeEvent((ProviderKey)this.provider.getKey()));
    }

    private boolean onPipelineStartError() {
        this.notification.fire((Object)new NotificationEvent(this.translationService.getTranslation("NewDeployWizard.PipelineStartErrorMessage"), NotificationEvent.NotificationType.ERROR));
        this.pageSelected(0);
        this.start();
        return false;
    }

    private void clear() {
        this.selectPipelinePage.clear();
        this.sourceConfigPage.clear();
    }
}

