/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.source;

import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.model.InternalGitSource;
import org.guvnor.ala.ui.model.Source;
import org.guvnor.ala.ui.service.SourceService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class SourceConfigurationPagePresenter
implements WizardPage {
    private final View view;
    private final Caller<SourceService> sourceService;
    private final Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;

    @Inject
    public SourceConfigurationPagePresenter(View view, Caller<SourceService> sourceService, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent) {
        this.view = view;
        this.sourceService = sourceService;
        this.wizardPageStatusChangeEvent = wizardPageStatusChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public String getTitle() {
        return this.view.getTitle();
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)this.isValid());
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public Source buildSource() {
        return new InternalGitSource(this.getOU(), this.getRepository(), this.getBranch(), this.getProject());
    }

    public void clear() {
        this.view.clear();
    }

    public void setup() {
        this.loadOUs();
    }

    public String getRuntime() {
        return this.view.getRuntimeName();
    }

    private String getBranch() {
        return this.view.getBranch();
    }

    private String getRepository() {
        return this.view.getRepository();
    }

    private String getOU() {
        return this.view.getOU();
    }

    private String getProject() {
        return this.view.getProject();
    }

    private boolean isValid() {
        return !this.getRuntime().trim().isEmpty() && !this.getOU().isEmpty() && !this.getRepository().isEmpty() && !this.getBranch().isEmpty() && !this.getProject().isEmpty();
    }

    public void disable() {
        this.view.disable();
    }

    protected void onRuntimeNameChange() {
        if (!this.view.getRuntimeName().trim().isEmpty()) {
            this.view.setRuntimeStatus(FormStatus.VALID);
        } else {
            this.view.setRuntimeStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onOrganizationalUnitChange() {
        if (!this.view.getOU().isEmpty()) {
            this.view.setOUStatus(FormStatus.VALID);
            this.view.clearRepositories();
            this.view.clearBranches();
            this.view.clearProjects();
            this.loadRepositories(this.getOU());
        } else {
            this.view.setOUStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onRepositoryChange() {
        if (!this.view.getRepository().isEmpty()) {
            this.view.setRepositoryStatus(FormStatus.VALID);
            this.view.clearBranches();
            this.view.clearProjects();
            this.loadBranches(this.getRepository());
        } else {
            this.view.setRepositoryStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onBranchChange() {
        if (!this.view.getBranch().isEmpty()) {
            this.view.setBranchStatus(FormStatus.VALID);
            this.view.clearProjects();
            this.loadProjects(this.getRepository(), this.getBranch());
        } else {
            this.view.setBranchStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onProjectChange() {
        if (!this.view.getProject().isEmpty()) {
            this.view.setProjectStatus(FormStatus.VALID);
        } else {
            this.view.setProjectStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    private void loadOUs() {
        ((SourceService)this.sourceService.call(ous -> {
            this.view.clearOrganizationUnits();
            ous.forEach(this.view::addOrganizationUnit);
            this.view.clearRepositories();
            this.view.clearBranches();
            this.view.clearProjects();
        }, (ErrorCallback)new DefaultErrorCallback())).getOrganizationUnits();
    }

    private void loadRepositories(String ou) {
        ((SourceService)this.sourceService.call(repos -> {
            this.view.clearRepositories();
            repos.forEach(this.view::addRepository);
            this.view.clearBranches();
            this.view.clearProjects();
        }, (ErrorCallback)new DefaultErrorCallback())).getRepositories(ou);
    }

    private void loadBranches(String repository) {
        ((SourceService)this.sourceService.call(branches -> {
            this.view.clearBranches();
            branches.forEach(this.view::addBranch);
            this.view.clearProjects();
        }, (ErrorCallback)new DefaultErrorCallback())).getBranches(repository);
    }

    private void loadProjects(String repository, String branch) {
        ((SourceService)this.sourceService.call(projects -> {
            this.view.clearProjects();
            projects.forEach(project -> this.view.addProject(project.getProjectName()));
        }, (ErrorCallback)new DefaultErrorCallback())).getProjects(repository, branch);
    }

    private void onContentChange() {
        this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    public static interface View
    extends UberElement<SourceConfigurationPagePresenter> {
        public String getRuntimeName();

        public String getOU();

        public String getRepository();

        public String getBranch();

        public String getProject();

        public void setRuntimeStatus(FormStatus var1);

        public void setOUStatus(FormStatus var1);

        public void setRepositoryStatus(FormStatus var1);

        public void setBranchStatus(FormStatus var1);

        public void setProjectStatus(FormStatus var1);

        public void clear();

        public void disable();

        public void enable();

        public String getTitle();

        public void clearRepositories();

        public void addRepository(String var1);

        public void clearBranches();

        public void addBranch(String var1);

        public void clearOrganizationUnits();

        public void addOrganizationUnit(String var1);

        public void clearProjects();

        public void addProject(String var1);
    }
}

