/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.project;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.StyleHelper;
import org.guvnor.ala.ui.client.wizard.project.GAVConfigurationParamsPresenter;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
@Templated
public class GAVConfigurationParamsView
implements IsElement,
GAVConfigurationParamsPresenter.View {
    @Inject
    @DataField(value="group-id-form")
    private Div groupIdForm;
    @Inject
    @DataField(value="group-id")
    private TextInput groupId;
    @Inject
    @DataField(value="artifact-id-form")
    private Div artifactIdForm;
    @Inject
    @DataField(value="artifact-id")
    private TextInput artifactId;
    @Inject
    @DataField(value="version-form")
    private Div versionForm;
    @Inject
    @DataField(value="version")
    private TextInput version;
    @Inject
    @DataField(value="artifact-selector-container")
    private Div artifactSelectorContainer;
    @Inject
    private TranslationService translationService;
    private GAVConfigurationParamsPresenter presenter;

    public void init(GAVConfigurationParamsPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public String getWizardTitle() {
        return this.translationService.getTranslation("GAVConfigurationParamsView.Title");
    }

    @Override
    public void clear() {
        this.groupId.setValue("");
        this.artifactId.setValue("");
        this.version.setValue("");
        this.resetFormState();
    }

    @Override
    public String getGroupId() {
        return this.groupId.getValue();
    }

    @Override
    public void setGroupId(String value) {
        this.groupId.setValue(value);
    }

    @Override
    public String getArtifactId() {
        return this.artifactId.getValue();
    }

    @Override
    public void setArtifactId(String value) {
        this.artifactId.setValue(value);
    }

    @Override
    public String getVersion() {
        return this.version.getValue();
    }

    @Override
    public void setVersion(String value) {
        this.version.setValue(value);
    }

    @Override
    public void setArtifactSelectorPresenter(org.jboss.errai.common.client.api.IsElement artifactSelector) {
        this.artifactSelectorContainer.appendChild((Node)artifactSelector.getElement());
    }

    @Override
    public void setGroupIdStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.groupIdForm, status);
    }

    @Override
    public void setArtifactIdStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.artifactIdForm, status);
    }

    @Override
    public void setVersionStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.versionForm, status);
    }

    private void resetFormState() {
        this.setGroupIdStatus(FormStatus.VALID);
        this.setArtifactIdStatus(FormStatus.VALID);
        this.setVersionStatus(FormStatus.VALID);
    }

    @EventHandler(value={"group-id"})
    private void onGroupIdChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onGroupIdChange();
    }

    @EventHandler(value={"artifact-id"})
    private void onArtifactIdChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onArtifactIdChange();
    }

    @EventHandler(value={"version"})
    private void onVersionChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onVersionChange();
    }
}

