/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.project.artifact;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenter;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.client.widgets.ColumnType;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class ArtifactSelectorPresenter {
    private final View view;
    private final ArtifactListPresenter artifactListPresenter;
    protected final List<String> FORMATS = Arrays.asList("*.jar");
    protected static final String SEARCH_ALL_FILTER = "";
    private ArtifactSelectHandler artifactSelectHandler;

    @Inject
    public ArtifactSelectorPresenter(View view, ArtifactListPresenter artifactListPresenter) {
        this.view = view;
        this.artifactListPresenter = artifactListPresenter;
    }

    @PostConstruct
    public void init() {
        this.artifactListPresenter.notifyOnRefresh(false);
        this.artifactListPresenter.setup(new ColumnType[]{ColumnType.GAV});
        this.view.init(this);
        this.search(SEARCH_ALL_FILTER);
    }

    public View getView() {
        return this.view;
    }

    public void clear() {
        this.view.clear();
        this.search(SEARCH_ALL_FILTER);
    }

    public void refresh() {
        this.artifactListPresenter.refresh();
    }

    public ArtifactListView getArtifactListView() {
        return this.artifactListPresenter.getView();
    }

    public void setArtifactSelectHandler(ArtifactSelectHandler artifactSelectHandler) {
        this.artifactSelectHandler = artifactSelectHandler;
    }

    protected void onArtifactSelected(String pathSelected) {
        if (this.artifactSelectHandler != null) {
            this.artifactSelectHandler.onArtifactSelected(pathSelected);
        }
    }

    protected void onSearch() {
        this.artifactListPresenter.search(this.view.getFilter(), this.FORMATS);
    }

    private void search(String value) {
        this.artifactListPresenter.search(value, this.FORMATS);
    }

    public static interface ArtifactSelectHandler {
        public void onArtifactSelected(String var1);
    }

    public static interface View
    extends UberElement<ArtifactSelectorPresenter> {
        public String getFilter();

        public void clear();
    }
}

