/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.project.artifact;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.wizard.project.artifact.ArtifactSelectorPresenter;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.model.JarListPageRow;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class ArtifactSelectorView
implements IsElement,
ArtifactSelectorPresenter.View {
    @Inject
    @DataField(value="artifact-list-container")
    private Row artifactListContainer;
    @Inject
    @DataField(value="filter")
    private TextInput filter;
    @Inject
    @DataField(value="search-button")
    private Button search;
    @Inject
    private TranslationService translationService;
    private ArtifactSelectorPresenter presenter;

    public void init(ArtifactSelectorPresenter presenter) {
        this.presenter = presenter;
        ArtifactListView artifactListView = presenter.getArtifactListView();
        artifactListView.addColumn(this.buildSelectColumn(), this.getSelectColumnLabel());
        artifactListView.setContentHeight("200px");
        Style style = artifactListView.asWidget().getElement().getStyle();
        style.setMarginLeft(0.0, Style.Unit.PX);
        style.setMarginRight(0.0, Style.Unit.PX);
        this.artifactListContainer.add((IsWidget)artifactListView);
    }

    private Column<JarListPageRow, String> buildSelectColumn() {
        return new Column<JarListPageRow, String>((Cell)new ButtonCell(ButtonSize.EXTRA_SMALL)){
            {
                this.setFieldUpdater((FieldUpdater)new FieldUpdater<JarListPageRow, String>(){

                    public void update(int index, JarListPageRow row, String value) {
                        ArtifactSelectorView.this.presenter.onArtifactSelected(row.getPath());
                    }
                });
            }

            public String getValue(JarListPageRow row) {
                return ArtifactSelectorView.this.getSelectColumnLabel();
            }
        };
    }

    private String getSelectColumnLabel() {
        return this.translationService.getTranslation("ArtifactSelectorView.SelectColumn");
    }

    @Override
    public String getFilter() {
        return this.filter.getValue();
    }

    @Override
    public void clear() {
        this.filter.setValue("");
    }

    @EventHandler(value={"search-button"})
    private void onSearch(@ForEvent(value={"click"}) Event event) {
        this.presenter.onSearch();
    }
}

