/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.guvnor.ala.ui.client.widget.pipeline.stage.State;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.RuntimeStatus;

public class RuntimePresenterHelper {
    public static Collection<String> buildIconStyle(PipelineStatus status) {
        if (status == null) {
            return Collections.emptyList();
        }
        switch (status) {
            case FINISHED: {
                return Arrays.asList("pficon", "list-view-pf-icon-md", "pficon-ok", "list-view-pf-icon-success");
            }
            case SCHEDULED: 
            case RUNNING: {
                return Arrays.asList("fa", "list-view-pf-icon-md", "fa-circle-o-notch", "fa-spin");
            }
            case ERROR: {
                return Arrays.asList("pficon", "list-view-pf-icon-md", "pficon-error-circle-o", "list-view-pf-icon-danger");
            }
            case STOPPED: {
                return Arrays.asList("fa", "list-view-pf-icon-md", "fa-ban", "list-view-pf-icon-info");
            }
        }
        return Collections.emptyList();
    }

    public static RuntimeStatus buildRuntimeStatus(String status) {
        if (status == null) {
            return RuntimeStatus.UNKNOWN;
        }
        switch (status) {
            case "READY": {
                return RuntimeStatus.READY;
            }
            case "RUNNING": {
                return RuntimeStatus.RUNNING;
            }
            case "STOPPED": {
                return RuntimeStatus.STOPPED;
            }
            case "UNKNOWN": {
                return RuntimeStatus.UNKNOWN;
            }
        }
        return RuntimeStatus.UNKNOWN;
    }

    public static Collection<String> buildIconStyle(RuntimeStatus status) {
        switch (status) {
            case RUNNING: {
                return Arrays.asList("pficon", "list-view-pf-icon-md", "pficon-ok", "list-view-pf-icon-success");
            }
            case LOADING: {
                return Arrays.asList("fa", "list-view-pf-icon-md", "fa-circle-o-notch", "fa-spin");
            }
            case WARN: {
                return Arrays.asList("pficon", "list-view-pf-icon-md", "pficon-warning-triangle-o", "list-view-pf-icon-warning");
            }
            case STOPPED: 
            case READY: {
                return Arrays.asList("fa", "list-view-pf-icon-md", "fa-ban", "list-view-pf-icon-info");
            }
            case ERROR: {
                return Arrays.asList("pficon", "list-view-pf-icon-md", "pficon-error-circle-o", "list-view-pf-icon-danger");
            }
            case UNKNOWN: {
                return Arrays.asList("fa", "list-view-pf-icon-md", "fa-circle-o", "list-view-pf-icon-info");
            }
        }
        return Collections.emptyList();
    }

    public static State buildStageState(PipelineStatus stageStatus) {
        if (stageStatus == null) {
            return State.DONE;
        }
        switch (stageStatus) {
            case RUNNING: {
                return State.EXECUTING;
            }
            case ERROR: {
                return State.ERROR;
            }
            case STOPPED: {
                return State.STOPPED;
            }
        }
        return State.DONE;
    }
}

