/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.HasData;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigParamsPresenter;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;

@Dependent
@Templated
public class ContainerConfigParamsView
implements IsElement,
ContainerConfigParamsPresenter.View {
    @Inject
    @DataField(value="add-container-button")
    private Button addContainerButton;
    @DataField(value="containers-table")
    private SimpleTable<ContainerConfig> dataGrid = new SimpleTable();
    @Inject
    private TranslationService translationService;
    private ContainerConfigParamsPresenter presenter;

    public void init(ContainerConfigParamsPresenter presenter) {
        this.presenter = presenter;
        this.dataGrid.setColumnPickerButtonVisible(false);
        this.dataGrid.setToolBarVisible(false);
        this.dataGrid.setEmptyTableCaption(this.translationService.getTranslation("ContainerConfigParamsView.ContainersEmptyTableCaption"));
        this.addNameColumn();
        this.addGroupIdColumn();
        this.addArtifactIdColumn();
        this.addVersionColumn();
        this.addRemoveRowColumn();
    }

    @Override
    public String getWizardTitle() {
        return this.translationService.getTranslation("ContainerConfigParamsView.Title");
    }

    @Override
    public HasData<ContainerConfig> getDisplay() {
        return this.dataGrid;
    }

    private void addNameColumn() {
        Column<ContainerConfig, String> column = new Column<ContainerConfig, String>((Cell)new TextCell()){

            public String getValue(ContainerConfig containerConfig) {
                return containerConfig.getName();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("ContainerConfigParamsView.ContainerNameColumn"));
    }

    private void addGroupIdColumn() {
        Column<ContainerConfig, String> column = new Column<ContainerConfig, String>((Cell)new TextCell()){

            public String getValue(ContainerConfig containerConfig) {
                return containerConfig.getGroupId();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("ContainerConfigParamsView.GroupIdColumn"));
    }

    private void addArtifactIdColumn() {
        Column<ContainerConfig, String> column = new Column<ContainerConfig, String>((Cell)new TextCell()){

            public String getValue(ContainerConfig containerConfig) {
                return containerConfig.getArtifactId();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("ContainerConfigParamsView.ArtifactIdColumn"));
    }

    private void addVersionColumn() {
        Column<ContainerConfig, String> column = new Column<ContainerConfig, String>((Cell)new TextCell()){

            public String getValue(ContainerConfig containerConfig) {
                return containerConfig.getVersion();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("ContainerConfigParamsView.VersionColumn"));
    }

    private void addRemoveRowColumn() {
        ButtonCell buttonCell = new ButtonCell(IconType.TRASH, ButtonType.DANGER, ButtonSize.SMALL);
        Column<ContainerConfig, String> column = new Column<ContainerConfig, String>((Cell)buttonCell){

            public String getValue(ContainerConfig containerConfig) {
                return ContainerConfigParamsView.this.translationService.getTranslation("ContainerConfigParamsView.Delete");
            }
        };
        column.setFieldUpdater((index, containerConfig, value) -> this.presenter.onDeleteContainer((ContainerConfig)containerConfig));
        this.dataGrid.addColumn((Column)column, "");
        this.dataGrid.setColumnWidth((Column)column, 90.0, Style.Unit.PX);
    }

    @EventHandler(value={"add-container-button"})
    private void onAddContainer(@ForEvent(value={"click"}) Event event) {
        this.presenter.onAddContainer();
    }
}

