/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.providertype;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.wizard.providertype.item.ProviderTypeItemPresenter;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

public class EnableProviderTypePagePresenter
implements WizardPage {
    private final View view;
    private final Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    private final ManagedInstance<ProviderTypeItemPresenter> providerTypeItemPresenterInstance;
    private List<ProviderTypeItemPresenter> itemPresenters = new ArrayList<ProviderTypeItemPresenter>();

    @Inject
    public EnableProviderTypePagePresenter(View view, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent, ManagedInstance<ProviderTypeItemPresenter> providerTypeItemPresenterInstance) {
        this.view = view;
        this.wizardPageStatusChangeEvent = wizardPageStatusChangeEvent;
        this.providerTypeItemPresenterInstance = providerTypeItemPresenterInstance;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(List<Pair<ProviderType, ProviderTypeStatus>> providerTypeStatus) {
        this.view.clear();
        this.clearProviderTypes();
        ContentChangeHandler contentChangeHandler = this::onProviderTypeSelectionChange;
        providerTypeStatus.forEach(pair -> {
            ProviderTypeItemPresenter presenter = this.newProviderTypeItemPresenter();
            presenter.setup((ProviderType)pair.getK1(), (ProviderTypeStatus)pair.getK2());
            presenter.addContentChangeHandler(contentChangeHandler);
            this.itemPresenters.add(presenter);
            this.view.addProviderType(presenter.getView());
        });
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public void isComplete(Callback<Boolean> callback) {
        for (ProviderTypeItemPresenter providerType : this.itemPresenters) {
            if (!providerType.isSelected()) continue;
            callback.callback((Object)true);
            return;
        }
        callback.callback((Object)false);
    }

    public String getTitle() {
        return this.view.getTitle();
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public Collection<ProviderType> getSelectedProviderTypes() {
        ArrayList<ProviderType> result = new ArrayList<ProviderType>();
        for (ProviderTypeItemPresenter providerType : this.itemPresenters) {
            if (!providerType.isSelected()) continue;
            result.add(providerType.getProviderType());
        }
        return result;
    }

    private void onProviderTypeSelectionChange() {
        this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    protected ProviderTypeItemPresenter newProviderTypeItemPresenter() {
        return (ProviderTypeItemPresenter)this.providerTypeItemPresenterInstance.get();
    }

    protected List<ProviderTypeItemPresenter> getItemPresenters() {
        return this.itemPresenters;
    }

    private void clearProviderTypes() {
        this.itemPresenters.forEach(arg_0 -> this.providerTypeItemPresenterInstance.destroy(arg_0));
        this.itemPresenters.clear();
    }

    public static interface View
    extends UberElement<EnableProviderTypePagePresenter> {
        public void clear();

        public void addProviderType(IsElement var1);

        public String getTitle();
    }
}

