/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.wizard.AbstractMultiPageWizard;
import org.guvnor.ala.ui.client.wizard.providertype.EnableProviderTypePagePresenter;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.commons.data.Pair;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class EnableProviderTypeWizard
extends AbstractMultiPageWizard {
    private final EnableProviderTypePagePresenter enableProviderTypePage;
    private final Caller<ProviderTypeService> providerTypeService;
    private final Event<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent;

    @Inject
    public EnableProviderTypeWizard(EnableProviderTypePagePresenter enableProviderTypePage, TranslationService translationService, Caller<ProviderTypeService> providerTypeService, Event<NotificationEvent> notification, Event<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent) {
        super(translationService, notification);
        this.enableProviderTypePage = enableProviderTypePage;
        this.providerTypeService = providerTypeService;
        this.notification = notification;
        this.providerTypeListRefreshEvent = providerTypeListRefreshEvent;
    }

    @PostConstruct
    protected void init() {
        this.pages.add(this.enableProviderTypePage);
    }

    public void start(List<Pair<ProviderType, ProviderTypeStatus>> providerTypeStatus) {
        this.enableProviderTypePage.setup(providerTypeStatus);
        super.start();
    }

    public String getTitle() {
        return this.translationService.getTranslation("EnableProviderTypeWizard.Title");
    }

    public int getPreferredHeight() {
        return 550;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void complete() {
        Collection<ProviderType> providerTypes = this.enableProviderTypePage.getSelectedProviderTypes();
        ((ProviderTypeService)this.providerTypeService.call(aVoid -> this.onEnableTypesSuccess(providerTypes), (message, throwable) -> this.onEnableTypesError())).enableProviderTypes(providerTypes);
    }

    private void onEnableTypesSuccess(Collection<ProviderType> providerTypes) {
        this.notification.fire((Object)new NotificationEvent(this.translationService.getTranslation("EnableProviderTypeWizard.ProviderTypeEnableSuccessMessage"), NotificationEvent.NotificationType.SUCCESS));
        EnableProviderTypeWizard.super.complete();
        this.providerTypeListRefreshEvent.fire((Object)new ProviderTypeListRefreshEvent((ProviderTypeKey)providerTypes.iterator().next().getKey()));
    }

    private boolean onEnableTypesError() {
        this.notification.fire((Object)new NotificationEvent(this.translationService.getTranslation("EnableProviderTypeWizard.ProviderTypeEnableErrorMessage"), NotificationEvent.NotificationType.ERROR));
        this.start();
        return false;
    }
}

