/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.wizard.AbstractMultiPageWizard;
import org.guvnor.ala.ui.client.wizard.provider.ProviderConfigurationPagePresenter;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.service.ProviderService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class NewProviderWizard
extends AbstractMultiPageWizard {
    private final ProviderConfigurationPagePresenter providerConfigurationPage;
    private final ClientProviderHandlerRegistry handlerRegistry;
    private final PopupHelper popupHelper;
    private final Caller<ProviderService> providerService;
    private final Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    private ProviderType providerType;
    private Map<ProviderTypeKey, ProviderConfigurationForm> providerConfigurationFormMap = new HashMap<ProviderTypeKey, ProviderConfigurationForm>();
    private ProviderConfigurationForm providerConfigurationForm;

    @Inject
    public NewProviderWizard(ProviderConfigurationPagePresenter providerConfigurationPage, ClientProviderHandlerRegistry handlerRegistry, PopupHelper popupHelper, TranslationService translationService, Caller<ProviderService> providerService, Event<NotificationEvent> notification, Event<ProviderTypeSelectedEvent> providerTypeSelectedEvent) {
        super(translationService, notification);
        this.providerConfigurationPage = providerConfigurationPage;
        this.handlerRegistry = handlerRegistry;
        this.popupHelper = popupHelper;
        this.providerService = providerService;
        this.providerTypeSelectedEvent = providerTypeSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.pages.add(this.providerConfigurationPage);
    }

    public void start(ProviderType providerType) {
        this.providerType = providerType;
        this.providerConfigurationForm = this.getProviderConfigurationForm((ProviderTypeKey)providerType.getKey());
        if (this.providerConfigurationForm != null) {
            this.providerConfigurationPage.setProviderConfigurationForm(this.providerConfigurationForm);
            this.clear();
            super.start();
        } else {
            this.popupHelper.showErrorPopup(this.translationService.format("NewProviderWizard.ProviderNotProperlyConfiguredInSystemErrorMessage", new Object[]{providerType != null ? providerType.getName() : null}));
        }
    }

    public String getTitle() {
        return this.translationService.getTranslation("NewProviderWizard.Title");
    }

    public int getPreferredHeight() {
        return 550;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void complete() {
        ProviderConfiguration providerConfiguration = this.providerConfigurationPage.buildProviderConfiguration();
        ((ProviderService)this.providerService.call(aVoid -> this.onCreateProviderSuccess(providerConfiguration), this.popupHelper.getPopupErrorCallback())).createProvider(this.providerType, providerConfiguration);
    }

    private void onCreateProviderSuccess(ProviderConfiguration providerConfiguration) {
        this.notification.fire((Object)new NotificationEvent(this.translationService.getTranslation("NewProviderWizard.ProviderCreateSuccessMessage"), NotificationEvent.NotificationType.SUCCESS));
        NewProviderWizard.super.complete();
        this.providerTypeSelectedEvent.fire((Object)new ProviderTypeSelectedEvent((ProviderTypeKey)this.providerType.getKey(), providerConfiguration.getId()));
    }

    private void clear() {
        this.providerConfigurationPage.clear();
    }

    private ProviderConfigurationForm getProviderConfigurationForm(ProviderTypeKey providerTypeKey) {
        ProviderConfigurationForm form = this.providerConfigurationFormMap.get(providerTypeKey);
        if (form == null && this.handlerRegistry.isProviderInstalled(providerTypeKey) && ((ClientProviderHandler)this.handlerRegistry.getProviderHandler(providerTypeKey)).getFormResolver() != null) {
            form = ((ClientProviderHandler)this.handlerRegistry.getProviderHandler(providerTypeKey)).getFormResolver().newProviderConfigurationForm();
            this.providerConfigurationFormMap.put(providerTypeKey, form);
        }
        return form;
    }
}

