/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.release;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.FluidRow;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.PasswordTextBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.release.ReleaseConfigurationPresenter;
import org.guvnor.asset.management.client.i18n.Constants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ReleaseConfigurationViewImpl
extends Composite
implements ReleaseConfigurationPresenter.ReleaseConfigurationView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @Inject
    private PlaceManager placeManager;
    private ReleaseConfigurationPresenter presenter;
    @UiField
    public ListBox chooseRepositoryBox;
    @UiField
    public ListBox chooseBranchBox;
    @UiField
    public Button releaseButton;
    @UiField
    public TextBox userNameText;
    @UiField
    public PasswordTextBox passwordText;
    @UiField
    public TextBox serverURLText;
    @UiField
    public CheckBox deployToRuntimeCheck;
    @UiField
    public TextBox versionText;
    @UiField
    public TextBox currentVersionText;
    @UiField
    public FluidRow deployToRuntimeRow;
    @UiField
    public FluidRow usernameRow;
    @UiField
    public FluidRow passwordRow;
    @UiField
    public FluidRow serverURLRow;
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public ReleaseConfigurationViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(final ReleaseConfigurationPresenter presenter) {
        this.presenter = presenter;
        this.currentVersionText.setReadOnly(true);
        presenter.loadServerSetting();
        this.chooseRepositoryBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String value = ReleaseConfigurationViewImpl.this.chooseRepositoryBox.getValue();
                presenter.loadBranches(value);
                presenter.loadRepositoryStructure(value);
            }
        });
        presenter.loadRepositories();
    }

    @Override
    public void showHideDeployToRuntimeSection(boolean show) {
        if (show) {
            this.deployToRuntimeRow.setVisible(true);
            this.usernameRow.setVisible(true);
            this.passwordRow.setVisible(true);
            this.serverURLRow.setVisible(true);
            this.userNameText.setEnabled(false);
            this.passwordText.setEnabled(false);
            this.serverURLText.setEnabled(false);
            this.deployToRuntimeCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        ReleaseConfigurationViewImpl.this.userNameText.setEnabled(true);
                        ReleaseConfigurationViewImpl.this.passwordText.setEnabled(true);
                        ReleaseConfigurationViewImpl.this.serverURLText.setEnabled(true);
                    } else {
                        ReleaseConfigurationViewImpl.this.userNameText.setEnabled(false);
                        ReleaseConfigurationViewImpl.this.passwordText.setEnabled(false);
                        ReleaseConfigurationViewImpl.this.serverURLText.setEnabled(false);
                    }
                }
            });
        } else {
            this.deployToRuntimeRow.setVisible(false);
            this.usernameRow.setVisible(false);
            this.passwordRow.setVisible(false);
            this.serverURLRow.setVisible(false);
        }
    }

    @UiHandler(value={"releaseButton"})
    public void releaseButton(ClickEvent e) {
        this.presenter.releaseProject(this.chooseRepositoryBox.getValue(), this.chooseBranchBox.getValue(), this.userNameText.getText(), this.passwordText.getText(), this.serverURLText.getText(), this.deployToRuntimeCheck.getValue(), this.versionText.getText());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public ListBox getChooseBranchBox() {
        return this.chooseBranchBox;
    }

    @Override
    public ListBox getChooseRepositoryBox() {
        return this.chooseRepositoryBox;
    }

    @Override
    public TextBox getCurrentVersionText() {
        return this.currentVersionText;
    }

    @Override
    public TextBox getVersionText() {
        return this.versionText;
    }

    static interface Binder
    extends UiBinder<Widget, ReleaseConfigurationViewImpl> {
    }
}

