/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.asset.management.backend.service.AssetManagementServiceCallerMock;
import org.guvnor.asset.management.backend.service.RepositoryStructureServiceCallerMock;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizard;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.WizardTestUtils;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageTest;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageView;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePageTest;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePageView;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.OrganizationalUnitServiceCallerMock;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryServiceCallerMock;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.wizards.Wizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class CreateRepositoryWizardTest {
    private static final String REPOSITORY_NAME = "RepositoryName";
    private static final String ORGANIZATIONAL_UNIT = "OrganizationalUnit1";
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_DESCRIPTION = "Project description";
    private static final String GROUP_ID = "GroupId";
    private static final String ARTIFACT_ID = "ArtifactId";
    private static final String VERSION = "Version";
    RepositoryInfoPageTest.RepositoryInfoPageExtended infoPage;
    RepositoryStructurePageTest.RepositoryStructurePageExtended structurePage;
    @GwtMock
    RepositoryInfoPageView infoPageView;
    @GwtMock
    RepositoryStructurePageView structurePageView;
    @GwtMock
    WizardView view;
    CreateRepositoryWizard createRepositoryWizard;
    CreateRepositoryWizardModel model;
    Repository expectedRepository = (Repository)Mockito.mock(Repository.class);
    OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
    RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    RepositoryStructureService repositoryStructureService = (RepositoryStructureService)Mockito.mock(RepositoryStructureService.class);
    AssetManagementService assetManagementService = (AssetManagementService)Mockito.mock(AssetManagementService.class);
    List<OrganizationalUnit> organizationalUnits = RepositoryInfoPageTest.buildOrganiztionalUnits();
    SessionInfo sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);
    KieWorkbenchACL kieACL = (KieWorkbenchACL)Mockito.mock(KieWorkbenchACL.class);
    User user = (User)Mockito.mock(User.class);
    WizardTestUtils.NotificationEventMock notificationEvent;

    @Before
    public void init() {
        HashSet<1> userRoles = new HashSet<1>();
        userRoles.add(new Role(){

            public String getName() {
                return "mock-role";
            }
        });
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"mock-user");
        Mockito.when((Object)this.user.getRoles()).thenReturn(userRoles);
        HashSet<String> grantedRoles = new HashSet<String>();
        grantedRoles.add("mock-role");
        Mockito.when((Object)this.kieACL.getGrantedRoles("wb_configure_repository")).thenReturn(grantedRoles);
        WizardTestUtils.WizardPageStatusChangeEventMock event = new WizardTestUtils.WizardPageStatusChangeEventMock();
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        this.infoPage = new RepositoryInfoPageTest.RepositoryInfoPageExtended(this.infoPageView, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, event);
        this.structurePage = new RepositoryStructurePageTest.RepositoryStructurePageExtended(this.structurePageView, new RepositoryStructureServiceCallerMock(this.repositoryStructureService), event);
        this.model = new CreateRepositoryWizardModel();
        this.notificationEvent = new WizardTestUtils.NotificationEventMock();
        this.createRepositoryWizard = new CreateRepositoryWizardExtended(this.infoPage, this.structurePage, this.model, (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), new RepositoryStructureServiceCallerMock(this.repositoryStructureService), new AssetManagementServiceCallerMock(this.assetManagementService), this.notificationEvent, this.kieACL, this.sessionInfo, this.view, event);
    }

    @Test
    public void testUnmanagedRepositoryCompletedTest() {
        Mockito.when((Object)this.infoPageView.getName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.infoPageView.getOrganizationalUnitName()).thenReturn((Object)ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)false);
        Mockito.when((Object)this.repositoryService.validateRepositoryName(REPOSITORY_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.normalizeRepositoryName(REPOSITORY_NAME)).thenReturn((Object)REPOSITORY_NAME);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("managed", false);
        Mockito.when((Object)this.repositoryService.createRepository(this.organizationalUnits.get(0), "git", REPOSITORY_NAME, env)).thenReturn((Object)this.expectedRepository);
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (Map)Mockito.eq(env));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)this.model.getRepositoryName());
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)this.model.getOrganizationalUnit());
        Assert.assertEquals((Object)false, (Object)this.model.isManged());
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    @Test
    public void testManagedRepositoryMultiCompletedTest() {
        Mockito.when((Object)this.infoPageView.getName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.infoPageView.getOrganizationalUnitName()).thenReturn((Object)ORGANIZATIONAL_UNIT);
        Mockito.when((Object)this.infoPageView.isManagedRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.validateRepositoryName(REPOSITORY_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.normalizeRepositoryName(REPOSITORY_NAME)).thenReturn((Object)REPOSITORY_NAME);
        this.createRepositoryWizard.start();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        this.infoPage.onManagedRepositoryChange();
        Mockito.when((Object)this.structurePageView.getProjectName()).thenReturn((Object)PROJECT_NAME);
        Mockito.when((Object)this.structurePageView.getProjectDescription()).thenReturn((Object)PROJECT_DESCRIPTION);
        Mockito.when((Object)this.structurePageView.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.structurePageView.getArtifactId()).thenReturn((Object)ARTIFACT_ID);
        Mockito.when((Object)this.structurePageView.getVersion()).thenReturn((Object)VERSION);
        Mockito.when((Object)this.structurePageView.isConfigureRepository()).thenReturn((Object)true);
        Mockito.when((Object)this.structurePageView.isMultiModule()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(PROJECT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(GROUP_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(ARTIFACT_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VERSION)).thenReturn((Object)true);
        this.createRepositoryWizard.pageSelected(1);
        this.structurePage.onProjectNameChange();
        this.structurePage.onProjectDescriptionChange();
        this.structurePage.onGroupIdChange();
        this.structurePage.onArtifactIdChange();
        this.structurePage.onVersionChange();
        this.structurePage.onConfigureRepositoryChange();
        this.structurePage.onMultiModuleChange();
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("managed", true);
        Mockito.when((Object)this.repositoryService.createRepository(this.organizationalUnits.get(0), "git", REPOSITORY_NAME, env)).thenReturn((Object)this.expectedRepository);
        Mockito.when((Object)this.expectedRepository.getAlias()).thenReturn((Object)REPOSITORY_NAME);
        this.createRepositoryWizard.complete();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Mockito.eq((Object)this.organizationalUnits.get(0)), (String)Mockito.eq((Object)"git"), (String)Mockito.eq((Object)REPOSITORY_NAME), (Map)Mockito.eq(env));
        Path pathToPom = (Path)Mockito.mock(Path.class);
        POM pom = new POM();
        pom.setName(PROJECT_NAME);
        pom.setDescription(PROJECT_DESCRIPTION);
        pom.getGav().setGroupId(GROUP_ID);
        pom.getGav().setArtifactId(ARTIFACT_ID);
        pom.getGav().setVersion(VERSION);
        String baseUrl = "";
        Mockito.when((Object)this.repositoryStructureService.initRepositoryStructure(pom, "", this.expectedRepository, true)).thenReturn((Object)pathToPom);
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).initRepositoryStructure((POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)""), (Repository)Mockito.eq((Object)this.expectedRepository), Mockito.eq((boolean)true));
        ((AssetManagementService)Mockito.verify((Object)this.assetManagementService, (VerificationMode)Mockito.times((int)1))).configureRepository((String)Mockito.eq((Object)REPOSITORY_NAME), (String)Mockito.eq((Object)"master"), (String)Mockito.eq((Object)"dev"), (String)Mockito.eq((Object)"release"), (String)Mockito.eq((Object)VERSION));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)this.model.getRepositoryName());
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)this.model.getOrganizationalUnit());
        Assert.assertEquals((Object)true, (Object)this.model.isManged());
        Assert.assertEquals((Object)true, (Object)this.model.isMultiModule());
        Assert.assertEquals((Object)true, (Object)this.model.isConfigureRepository());
        Assert.assertEquals((Object)PROJECT_NAME, (Object)this.model.getProjectName());
        Assert.assertEquals((Object)PROJECT_DESCRIPTION, (Object)this.model.getProjectDescription());
        Assert.assertEquals((Object)GROUP_ID, (Object)this.model.getGroupId());
        Assert.assertEquals((Object)ARTIFACT_ID, (Object)this.model.getArtifactId());
        Assert.assertEquals((Object)VERSION, (Object)this.model.getVersion());
        WizardTestUtils.assertWizardComplete(true, (Wizard)this.createRepositoryWizard);
    }

    public static class CreateRepositoryWizardExtended
    extends CreateRepositoryWizard {
        public CreateRepositoryWizardExtended(RepositoryInfoPage infoPage, RepositoryStructurePage structurePage, CreateRepositoryWizardModel model, Caller<RepositoryService> repositoryService, Caller<RepositoryStructureService> repositoryStructureService, Caller<AssetManagementService> assetManagementService, Event<NotificationEvent> notification, KieWorkbenchACL kieACL, SessionInfo sessionInfo, WizardView view, WizardTestUtils.WizardPageStatusChangeEventMock event) {
            super(infoPage, structurePage, model, repositoryService, repositoryStructureService, assetManagementService, notification, kieACL, sessionInfo);
            this.view = view;
            this.setupPages();
            event.addEventHandler(new WizardTestUtils.WizardPageStatusChangeHandler(){

                @Override
                public void handleEvent(WizardPageStatusChangeEvent event) {
                    CreateRepositoryWizardExtended.this.onStatusChange(event);
                }
            });
        }
    }
}

