/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.forms.promote;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.guvnor.asset.management.client.editors.forms.promote.SelectAssetsToPromotePresenter;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;

@Dependent
public class SelectAssetsToPromoteViewImpl
extends Composite
implements SelectAssetsToPromotePresenter.SelectAssetsToPromoteView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private SelectAssetsToPromotePresenter presenter;
    private boolean isReadOnly = false;
    @UiField
    public TextBox sourceBranchBox;
    @UiField
    public CheckBox requiresReviewCheckBox;
    @UiField
    public ListBox filesInTheBranchList;
    @UiField
    public ListBox filesToPromoteList;
    @UiField
    public Button promoteAllFilesButton;
    @UiField
    public Button promoteSelectedFilesButton;

    public SelectAssetsToPromoteViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(SelectAssetsToPromotePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clearFilesInBranch() {
        this.filesInTheBranchList.clear();
    }

    @Override
    public void addFieldInBranch(String file) {
        this.filesInTheBranchList.addItem(file);
    }

    @Override
    public void clearFilesToPromote() {
        this.filesToPromoteList.clear();
    }

    @Override
    public void addFileToPromote(String file) {
        this.filesToPromoteList.addItem(file);
    }

    @Override
    public void setSourceBranch(String branch) {
        this.sourceBranchBox.setText(branch);
    }

    @UiHandler(value={"promoteSelectedFilesButton"})
    public void promoteSelectedFilesButton(ClickEvent e) {
        for (int i = 0; i < this.filesInTheBranchList.getItemCount(); ++i) {
            if (!this.filesInTheBranchList.isItemSelected(i)) continue;
            String file = this.filesInTheBranchList.getValue(i);
            this.presenter.addFileToPromotedList(file);
            this.filesInTheBranchList.removeItem(i);
            --i;
        }
    }

    @UiHandler(value={"promoteAllFilesButton"})
    public void promoteAllFilesButton(ClickEvent e) {
        for (int i = 0; i < this.filesInTheBranchList.getItemCount(); ++i) {
            String file = this.filesInTheBranchList.getValue(i);
            this.presenter.addFileToPromotedList(file);
        }
        this.filesInTheBranchList.clear();
    }

    @UiHandler(value={"filesToPromoteList"})
    public void removeFileFromPromotedList(ClickEvent e) {
        int selectedIndex = this.filesToPromoteList.getSelectedIndex();
        String file = this.filesToPromoteList.getValue(selectedIndex);
        this.filesToPromoteList.removeItem(selectedIndex);
        this.presenter.removeFileFromPromotedList(file);
    }

    @UiHandler(value={"requiresReviewCheckBox"})
    public void checkRequiredReviewCheckBox(ClickEvent e) {
        this.presenter.setRequiresReview(this.requiresReviewCheckBox.getValue());
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        this.filesInTheBranchList.setEnabled(!readOnly);
        this.filesToPromoteList.setEnabled(!readOnly);
        this.promoteSelectedFilesButton.setEnabled(!readOnly);
        this.promoteAllFilesButton.setEnabled(!readOnly);
        this.requiresReviewCheckBox.setEnabled(!readOnly);
        this.sourceBranchBox.setEnabled(!readOnly);
    }

    static interface Binder
    extends UiBinder<Widget, SelectAssetsToPromoteViewImpl> {
    }
}

