/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.forms.promote;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.asset.management.client.i18n.Constants;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.forms.GetFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.RequestFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.SetFormParamsEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="SelectAssetsToPromote Form")
public class SelectAssetsToPromotePresenter {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private SelectAssetsToPromoteView view;
    private Event<GetFormParamsEvent> getFormParamsEvent;
    private CommitsReader commitsReader;
    private PlaceRequest place;
    protected Map<String, String> commitsPerFile;
    protected List<String> filesToPromote;
    protected Boolean requiresReview = Boolean.FALSE;

    @Inject
    public SelectAssetsToPromotePresenter(SelectAssetsToPromoteView view, Event<GetFormParamsEvent> getFormParamsEvent, CommitsReader commitsReader) {
        this.view = view;
        this.getFormParamsEvent = getFormParamsEvent;
        this.commitsReader = commitsReader;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public void setInputMap(@Observes SetFormParamsEvent event) {
        Map params = event.getParams();
        String files = (String)params.get("in_list_of_files");
        this.commitsPerFile = new HashMap<String, String>();
        this.filesToPromote = new ArrayList<String>();
        this.commitsPerFile = this.commitsReader.getCommitsPerFile((String)params.get("in_commits_per_file"));
        String[] filesArray = files.split(",");
        this.view.setSourceBranch((String)params.get("in_source_branch_name"));
        this.view.clearFilesToPromote();
        this.view.clearFilesInBranch();
        for (String file : filesArray) {
            this.view.addFieldInBranch(file);
        }
        this.view.setReadOnly(event.isReadOnly());
    }

    public void getOutputMap(@Observes RequestFormParamsEvent event) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        String out_commits = "";
        for (String selectedFile : this.filesToPromote) {
            String commits = this.commitsPerFile.get(selectedFile);
            if (commits == null || commits.length() == 0 || out_commits.contains(commits)) continue;
            if (out_commits.length() > 0) {
                out_commits = out_commits + ",";
            }
            out_commits = out_commits + commits;
        }
        outputMap.put("out_commits", out_commits);
        outputMap.put("out_requires_review", this.requiresReview);
        this.getFormParamsEvent.fire((Object)new GetFormParamsEvent(event.getAction(), outputMap));
    }

    public void addFileToPromotedList(String file) {
        this.filesToPromote.add(file);
        this.view.addFileToPromote(file);
    }

    public void removeFileFromPromotedList(String file) {
        this.filesToPromote.remove(file);
        this.view.addFieldInBranch(file);
    }

    public void setRequiresReview(Boolean requiresReview) {
        this.requiresReview = requiresReview;
    }

    public Boolean getRequiresReview() {
        return this.requiresReview;
    }

    public Map<String, String> getCommitsPerFile() {
        return this.commitsPerFile;
    }

    public List<String> getFilesToPromote() {
        return this.filesToPromote;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Promote_Assets();
    }

    @WorkbenchPartView
    public UberView<SelectAssetsToPromotePresenter> getView() {
        return this.view;
    }

    public static interface CommitsReader {
        public Map<String, String> getCommitsPerFile(String var1);
    }

    public static interface SelectAssetsToPromoteView
    extends UberView<SelectAssetsToPromotePresenter> {
        public void setSourceBranch(String var1);

        public void clearFilesToPromote();

        public void addFileToPromote(String var1);

        public void clearFilesInBranch();

        public void addFieldInBranch(String var1);

        public void setReadOnly(boolean var1);
    }
}

