/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure.promote;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.inject.Inject;
import org.guvnor.asset.management.client.i18n.Constants;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class PromoteScreenPopupViewImpl
extends BaseModal {
    private PromoteScreenPopupWidgetBinder uiBinder = (PromoteScreenPopupWidgetBinder)GWT.create(PromoteScreenPopupWidgetBinder.class);
    @Inject
    private User identity;
    @UiField
    FormGroup repositoryTextGroup;
    @UiField
    TextBox repositoryText;
    @UiField
    HelpBlock repositoryTextHelpBlock;
    @UiField
    FormGroup sourceBranchTextGroup;
    @UiField
    TextBox sourceBranchText;
    @UiField
    HelpBlock sourceBranchTextHelpBlock;
    @UiField
    FormGroup targetBranchListBoxGroup;
    @UiField
    ListBox targetBranchListBox;
    @UiField
    HelpBlock targetBranchListBoxHelpBlock;
    private Command callbackCommand;
    private final Command okCommand = new Command(){

        public void execute() {
            if (PromoteScreenPopupViewImpl.this.targetBranchListBox.getSelectedValue().equals(Constants.INSTANCE.Select_A_Branch()) || PromoteScreenPopupViewImpl.this.targetBranchListBox.getSelectedValue().equals(PromoteScreenPopupViewImpl.this.sourceBranchText.getText())) {
                PromoteScreenPopupViewImpl.this.targetBranchListBoxGroup.setValidationState(ValidationState.ERROR);
                PromoteScreenPopupViewImpl.this.targetBranchListBoxHelpBlock.setText(Constants.INSTANCE.FieldMandatory0("Target Branch"));
                return;
            }
            if (PromoteScreenPopupViewImpl.this.callbackCommand != null) {
                PromoteScreenPopupViewImpl.this.callbackCommand.execute();
            }
            PromoteScreenPopupViewImpl.this.hide();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            PromoteScreenPopupViewImpl.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public PromoteScreenPopupViewImpl() {
        this.setTitle(Constants.INSTANCE.Promote_Assets());
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setDataKeyboard(true);
        this.setFade(true);
        this.setRemoveOnHide(true);
        this.setBody((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
    }

    public void configure(String repositoryAlias, String branch, Collection<String> branches, Command command) {
        this.callbackCommand = command;
        this.sourceBranchText.setText(branch);
        this.repositoryText.setText(repositoryAlias);
        this.sourceBranchText.setReadOnly(true);
        this.repositoryText.setReadOnly(true);
        this.targetBranchListBox.clear();
        this.targetBranchListBox.addItem(Constants.INSTANCE.Select_A_Branch());
        for (String b : branches) {
            if (b.equals(branch)) continue;
            this.targetBranchListBox.addItem(b, b);
        }
    }

    public String getTargetBranch() {
        return this.targetBranchListBox.getSelectedValue();
    }

    static interface PromoteScreenPopupWidgetBinder
    extends UiBinder<Widget, PromoteScreenPopupViewImpl> {
    }
}

