/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.structure.HasModel;
import org.guvnor.asset.management.client.editors.repository.structure.configure.ConfigureScreenPopupViewImpl;
import org.guvnor.asset.management.client.editors.repository.structure.promote.PromoteScreenPopupViewImpl;
import org.guvnor.asset.management.client.editors.repository.structure.release.ReleaseScreenPopupViewImpl;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.context.ProjectContext;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
public class RepositoryStructureMenu
implements Menus {
    private final ProjectContext projectContext;
    private final ReleaseScreenPopupViewImpl releaseScreenPopupView;
    private final ConfigureScreenPopupViewImpl configureScreenPopupView;
    private final PromoteScreenPopupViewImpl promoteScreenPopupView;
    private final List<MenuItem> items = new ArrayList<MenuItem>();
    private MenuItem configure;
    private MenuItem release;
    private MenuItem promote;
    private boolean promoteIsGranted = false;
    private boolean configureIsGranted = false;
    private boolean releaseIsGranted = false;
    private Caller<AssetManagementService> assetManagementServices;

    @Inject
    public RepositoryStructureMenu(ProjectContext projectContext, Caller<AssetManagementService> assetManagementServices, ReleaseScreenPopupViewImpl releaseScreenPopupView, ConfigureScreenPopupViewImpl configureScreenPopupView, PromoteScreenPopupViewImpl promoteScreenPopupView) {
        this.projectContext = projectContext;
        this.assetManagementServices = assetManagementServices;
        this.releaseScreenPopupView = releaseScreenPopupView;
        this.configureScreenPopupView = configureScreenPopupView;
        this.promoteScreenPopupView = promoteScreenPopupView;
    }

    public void init(HasModel<RepositoryStructureModel> hasModel) {
        this.configure = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Configure()).withPermission("repository.configure")).respondsWith(this.getConfigureCommand(hasModel))).endMenu()).build().getItems().get(0);
        this.promote = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Promote()).withPermission("asset.promote")).respondsWith(this.getPromoteCommand())).endMenu()).build().getItems().get(0);
        this.release = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Release()).withPermission("project.release")).respondsWith(this.getReleaseCommand(hasModel))).endMenu()).build().getItems().get(0);
        this.items.add(this.configure);
        this.items.add(this.promote);
        this.items.add(this.release);
        MenuItem item = this.getItem(MenuItems.CONFIGURE_MENU_ITEM);
        this.configureIsGranted = item != null && item.isEnabled();
        item = this.getItem(MenuItems.PROMOTE_MENU_ITEM);
        this.promoteIsGranted = item != null && item.isEnabled();
        item = this.getItem(MenuItems.RELEASE_MENU_ITEM);
        this.releaseIsGranted = item != null && item.isEnabled();
    }

    private Command getConfigureCommand(final HasModel<RepositoryStructureModel> hasModel) {
        return new Command(){

            public void execute() {
                RepositoryStructureModel model = (RepositoryStructureModel)hasModel.getModel();
                if (model != null && (model.isSingleProject() || model.isMultiModule())) {
                    RepositoryStructureMenu.this.configureScreenPopupView.configure(RepositoryStructureMenu.this.projectContext.getActiveRepository().getAlias(), RepositoryStructureMenu.this.projectContext.getActiveBranch(), model.getActivePom().getGav().getVersion(), new com.google.gwt.user.client.Command(){

                        public void execute() {
                            RepositoryStructureMenu.this.configureRepository();
                            RepositoryStructureMenu.this.configureScreenPopupView.hide();
                        }
                    });
                    RepositoryStructureMenu.this.configureScreenPopupView.show();
                }
            }
        };
    }

    private Command getPromoteCommand() {
        return new Command(){

            public void execute() {
                RepositoryStructureMenu.this.promoteScreenPopupView.configure(RepositoryStructureMenu.this.projectContext.getActiveRepository().getAlias(), RepositoryStructureMenu.this.projectContext.getActiveBranch(), RepositoryStructureMenu.this.projectContext.getActiveRepository().getBranches(), new com.google.gwt.user.client.Command(){

                    public void execute() {
                        RepositoryStructureMenu.this.promoteChanges();
                        RepositoryStructureMenu.this.promoteScreenPopupView.hide();
                    }
                });
                RepositoryStructureMenu.this.promoteScreenPopupView.show();
            }
        };
    }

    private Command getReleaseCommand(final HasModel<RepositoryStructureModel> hasModel) {
        return new Command(){

            public void execute() {
                RepositoryStructureModel model = (RepositoryStructureModel)hasModel.getModel();
                if (model != null && (model.isSingleProject() || model.isMultiModule())) {
                    RepositoryStructureMenu.this.releaseScreenPopupView.configure(RepositoryStructureMenu.this.projectContext.getActiveRepository().getAlias(), RepositoryStructureMenu.this.projectContext.getActiveBranch(), RepositoryStructureMenu.this.trimSnapshotFromVersion(model.getActivePom().getGav().getVersion()), model.getActivePom().getGav().getVersion(), new com.google.gwt.user.client.Command(){

                        public void execute() {
                            RepositoryStructureMenu.this.releaseProject();
                            RepositoryStructureMenu.this.releaseScreenPopupView.hide();
                        }
                    });
                    RepositoryStructureMenu.this.releaseScreenPopupView.show();
                }
            }
        };
    }

    private String trimSnapshotFromVersion(String version) {
        if (version != null && version.endsWith("-SNAPSHOT")) {
            return version.replace("-SNAPSHOT", "");
        }
        return version;
    }

    private void configureRepository() {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).configureRepository(this.projectContext.getActiveRepository().getAlias(), this.projectContext.getActiveBranch(), this.configureScreenPopupView.getDevBranch(), this.configureScreenPopupView.getReleaseBranch(), this.configureScreenPopupView.getVersion());
    }

    private void promoteChanges() {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).promoteChanges(this.projectContext.getActiveRepository().getAlias(), this.projectContext.getActiveBranch(), this.promoteScreenPopupView.getTargetBranch());
    }

    private void releaseProject() {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).releaseProject(this.projectContext.getActiveRepository().getAlias(), this.projectContext.getActiveBranch(), this.releaseScreenPopupView.getUsername(), this.releaseScreenPopupView.getPassword(), this.getServerURL(), this.releaseScreenPopupView.getDeployToRuntime(), this.releaseScreenPopupView.getVersion());
    }

    private String getServerURL() {
        String serverURL = this.releaseScreenPopupView.getServerURL();
        if (serverURL != null && !serverURL.isEmpty() && serverURL.endsWith("/")) {
            return serverURL.substring(0, serverURL.length() - 1);
        }
        return serverURL;
    }

    private MenuItem getItem(MenuItems itemKey) {
        return this.getItemsMap().get((Object)itemKey);
    }

    public List<MenuItem> getItems() {
        return this.items;
    }

    public Map<Object, MenuItem> getItemsMap() {
        return new HashMap<Object, MenuItem>(){
            {
                this.put(MenuItems.CONFIGURE_MENU_ITEM, RepositoryStructureMenu.this.configure);
                this.put(MenuItems.PROMOTE_MENU_ITEM, RepositoryStructureMenu.this.promote);
                this.put(MenuItems.RELEASE_MENU_ITEM, RepositoryStructureMenu.this.release);
            }
        };
    }

    public void accept(MenuVisitor visitor) {
        if (visitor.visitEnter((Menus)this)) {
            for (MenuItem item : this.items) {
                item.accept(visitor);
            }
            visitor.visitLeave((Menus)this);
        }
    }

    public int getOrder() {
        return 0;
    }

    public void enableAssetsManagementMenu(boolean enable) {
        this.enableConfigure(this.configureIsGranted && enable);
        this.enablePromote(this.promoteIsGranted && enable);
        this.enableRelease(this.releaseIsGranted && enable);
    }

    private void enableConfigure(boolean enable) {
        this.configure.setEnabled(enable);
    }

    private void enablePromote(boolean enable) {
        this.promote.setEnabled(enable);
    }

    private void enableRelease(boolean enable) {
        this.release.setEnabled(enable);
    }

    public static enum MenuItems {
        CONFIGURE_MENU_ITEM,
        PROMOTE_MENU_ITEM,
        RELEASE_MENU_ITEM;

    }
}

