/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.structure.HasModel;
import org.guvnor.asset.management.client.editors.repository.structure.configure.ConfigureScreenPopupViewImpl;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.context.ProjectContext;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
public class RepositoryStructureMenu
implements Menus {
    private final ProjectContext projectContext;
    private final ConfigureScreenPopupViewImpl configureScreenPopupView;
    private final List<MenuItem> items = new ArrayList<MenuItem>();
    private MenuItem configure;
    private boolean configureIsGranted = false;
    private Caller<AssetManagementService> assetManagementServices;

    @Inject
    public RepositoryStructureMenu(ProjectContext projectContext, Caller<AssetManagementService> assetManagementServices, ConfigureScreenPopupViewImpl configureScreenPopupView) {
        this.projectContext = projectContext;
        this.assetManagementServices = assetManagementServices;
        this.configureScreenPopupView = configureScreenPopupView;
    }

    public void init(HasModel<RepositoryStructureModel> hasModel) {
        this.configure = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Configure()).withPermission("repository.configure")).respondsWith(this.getConfigureCommand(hasModel))).endMenu()).build().getItems().get(0);
        this.items.add(this.configure);
        MenuItem item = this.getItem(MenuItems.CONFIGURE_MENU_ITEM);
        this.configureIsGranted = item != null && item.isEnabled();
    }

    private Command getConfigureCommand(final HasModel<RepositoryStructureModel> hasModel) {
        return new Command(){

            public void execute() {
                RepositoryStructureModel model = (RepositoryStructureModel)hasModel.getModel();
                if (model != null && (model.isSingleProject() || model.isMultiModule())) {
                    RepositoryStructureMenu.this.configureScreenPopupView.configure(RepositoryStructureMenu.this.projectContext.getActiveRepository().getAlias(), RepositoryStructureMenu.this.projectContext.getActiveBranch(), model.getActivePom().getGav().getVersion(), new com.google.gwt.user.client.Command(){

                        public void execute() {
                            RepositoryStructureMenu.this.configureRepository();
                            RepositoryStructureMenu.this.configureScreenPopupView.hide();
                        }
                    });
                    RepositoryStructureMenu.this.configureScreenPopupView.show();
                }
            }
        };
    }

    private String trimSnapshotFromVersion(String version) {
        if (version != null && version.endsWith("-SNAPSHOT")) {
            return version.replace("-SNAPSHOT", "");
        }
        return version;
    }

    private void configureRepository() {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).configureRepository(this.projectContext.getActiveRepository().getAlias(), this.projectContext.getActiveBranch(), this.configureScreenPopupView.getDevBranch(), this.configureScreenPopupView.getReleaseBranch(), this.configureScreenPopupView.getVersion());
    }

    private MenuItem getItem(MenuItems itemKey) {
        return this.getItemsMap().get((Object)itemKey);
    }

    public List<MenuItem> getItems() {
        return this.items;
    }

    public Map<Object, MenuItem> getItemsMap() {
        return new HashMap<Object, MenuItem>(){
            {
                this.put(MenuItems.CONFIGURE_MENU_ITEM, RepositoryStructureMenu.this.configure);
            }
        };
    }

    public void accept(MenuVisitor visitor) {
        if (visitor.visitEnter((Menus)this)) {
            for (MenuItem item : this.items) {
                item.accept(visitor);
            }
            visitor.visitLeave((Menus)this);
        }
    }

    public int getOrder() {
        return 0;
    }

    public void enableAssetsManagementMenu(boolean enable) {
        this.enableConfigure(this.configureIsGranted && enable);
    }

    private void enableConfigure(boolean enable) {
        this.configure.setEnabled(enable);
    }

    public static enum MenuItems {
        CONFIGURE_MENU_ITEM;

    }
}

