/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.conf;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtPresenter;
import org.guvnor.asset.management.client.editors.common.BaseAssetsMgmtView;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Repository Configuration")
public class RepositoryConfigurationPresenter
extends BaseAssetsMgmtPresenter {
    @Inject
    protected ErrorPopupPresenter errorPopup;
    @Inject
    RepositoryConfigurationView view;
    @Inject
    private Event<BeforeClosePlaceEvent> closePlaceEvent;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Repository_Configuration();
    }

    @WorkbenchPartView
    public UberView<RepositoryConfigurationPresenter> getView() {
        return this.view;
    }

    @Override
    @PostConstruct
    public void init() {
        this.baseView = this.view;
    }

    public void loadRepositoryStructure(String repositoryAlias) {
        if (!repositoryAlias.equals(this.constants.Select_Repository())) {
            for (Repository repository : this.getRepositories()) {
                if (!repository.getAlias().equals(repositoryAlias)) continue;
                this.load(repository);
                return;
            }
        }
    }

    private void load(Repository repository) {
        ((RepositoryStructureService)this.repositoryStructureServices.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

            public void callback(RepositoryStructureModel model) {
                POM pom = RepositoryConfigurationPresenter.this.getPom(model);
                if (pom != null) {
                    RepositoryConfigurationPresenter.this.view.setCurrentVersionText(pom.getGav().getVersion().replace("-SNAPSHOT", ""));
                    RepositoryConfigurationPresenter.this.view.setVersionText(pom.getGav().getVersion().replace("-SNAPSHOT", ""));
                } else {
                    RepositoryConfigurationPresenter.this.view.setCurrentVersionText(RepositoryConfigurationPresenter.this.constants.No_Project_Structure_Available());
                    RepositoryConfigurationPresenter.this.view.setVersionText("1.0.0");
                }
            }
        })).load(repository, repository.getDefaultBranch());
    }

    private POM getPom(RepositoryStructureModel model) {
        if (model != null && (model.isSingleProject() || model.isMultiModule())) {
            return model.getActivePom();
        }
        return null;
    }

    public void configureRepository(String repository, String sourceBranch, String devBranch, String releaseBranch, String version) {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
                RepositoryConfigurationPresenter.this.view.displayNotification("Repository Configuration Started!");
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                RepositoryConfigurationPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).configureRepository(repository, sourceBranch, devBranch, releaseBranch, version);
    }

    @OnOpen
    public void onOpen() {
        this.view.getChooseRepositoryBox().setFocus(true);
    }

    public static interface RepositoryConfigurationView
    extends UberView<RepositoryConfigurationPresenter>,
    BaseAssetsMgmtView {
        public void setCurrentVersionText(String var1);

        public void setVersionText(String var1);
    }
}

