/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.asset.management.client.editors.repository.structure.ActionHistory;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryManagedStatusUpdater;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectWizard;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryManagedStatusUpdaterTest {
    @GwtMock
    Constants constants;
    @Mock
    RepositoryStructureService service;
    @Mock
    ProjectWizard wizard;
    @Mock
    HasBusyIndicator view;
    @Mock
    RepositoryStructureView.Presenter presenter;
    private RepositoryManagedStatusUpdater updater;
    @Mock
    private Repository repository;
    @Mock
    private Repository updatedRepository;
    @Mock
    private ActionHistory history;
    @Captor
    ArgumentCaptor<Callback<Project>> callbackArgumentCaptor;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.service.updateManagedStatus((Repository)Mockito.eq((Object)this.repository), Mockito.anyBoolean())).thenReturn((Object)this.updatedRepository);
        this.updater = new RepositoryManagedStatusUpdater((Caller)new CallerMock((Object)this.service), this.wizard);
        this.updater.bind(this.view, this.history, this.presenter);
    }

    @Test
    public void testUpdateNonManaged() throws Exception {
        this.updater.updateNonManaged(this.repository, "master");
        ((HasBusyIndicator)Mockito.verify((Object)this.view)).showBusyIndicator("CreatingRepositoryStructure");
        ((RepositoryStructureService)Mockito.verify((Object)this.service)).updateManagedStatus(this.repository, false);
        ((RepositoryStructureView.Presenter)Mockito.verify((Object)this.presenter)).loadModel(this.updatedRepository, "master");
    }

    @Test
    public void testInitSingleProject() throws Exception {
        this.updater.initSingleProject(this.repository, "master");
        ((ProjectWizard)Mockito.verify((Object)this.wizard)).initialise((POM)Mockito.any(POM.class));
        ((ProjectWizard)Mockito.verify((Object)this.wizard)).start((Callback)this.callbackArgumentCaptor.capture(), Mockito.eq((boolean)false));
        Project project = new Project();
        ((Callback)this.callbackArgumentCaptor.getValue()).callback((Object)project);
        ((ActionHistory)Mockito.verify((Object)this.history)).setLastAddedModule(project);
        ((RepositoryStructureService)Mockito.verify((Object)this.service)).updateManagedStatus(this.repository, true);
        ((RepositoryStructureView.Presenter)Mockito.verify((Object)this.presenter)).loadModel(this.updatedRepository, "master");
    }

    @Test
    public void testInitSingleProjectNullProject() throws Exception {
        this.updater.initSingleProject(this.repository, "master");
        ((ProjectWizard)Mockito.verify((Object)this.wizard)).initialise((POM)Mockito.any(POM.class));
        ((ProjectWizard)Mockito.verify((Object)this.wizard)).start((Callback)this.callbackArgumentCaptor.capture(), Mockito.eq((boolean)false));
        ((Callback)this.callbackArgumentCaptor.getValue()).callback(null);
        ((ActionHistory)Mockito.verify((Object)this.history)).setLastAddedModule(null);
        ((RepositoryStructureService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).updateManagedStatus((Repository)Mockito.any(Repository.class), Mockito.anyBoolean());
        ((RepositoryStructureView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).loadModel((Repository)Mockito.any(Repository.class), Mockito.anyString());
    }
}

