/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.inbox.backend.server.InboxPageRowBuilder;
import org.guvnor.inbox.backend.server.MailboxService;
import org.guvnor.inbox.backend.server.PageResponseBuilder;
import org.guvnor.inbox.model.InboxPageRequest;
import org.guvnor.inbox.model.InboxPageRow;
import org.guvnor.inbox.service.InboxService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.paging.PageResponse;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class InboxServiceImpl
implements InboxService {
    static final int MAX_RECENT_EDITED = 200;
    public static final String RECENT_EDITED_ID = "recentEdited";
    public static final String RECENT_VIEWED_ID = "recentViewed";
    public static final String INCOMING_ID = "incoming";
    private static final String INBOX = "inbox";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private UserServicesImpl userServices;
    @Inject
    @SessionScoped
    private Identity identity;
    @Inject
    MailboxService mailboxService;
    @Inject
    InboxPageRowBuilder inboxPageRowBuilder;

    public PageResponse<InboxPageRow> loadInbox(InboxPageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        String inboxName = request.getInboxName();
        PageResponse<InboxPageRow> response = new PageResponse<InboxPageRow>();
        List<InboxEntry> entries = this.loadEntries(inboxName);
        Iterator<InboxEntry> iterator = entries.iterator();
        List<InboxPageRow> rowList = this.inboxPageRowBuilder.withPageRequest(request).withIdentity(this.identity).withContent(iterator).build();
        response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(entries.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(!iterator.hasNext()).build();
        return response;
    }

    public List<InboxEntry> loadEntries(String inboxName) {
        List<InboxEntry> entries = inboxName.equals(RECENT_VIEWED_ID) ? this.loadRecentOpened() : (inboxName.equals(RECENT_EDITED_ID) ? this.loadRecentEdited() : this.loadIncoming());
        return entries;
    }

    public List<InboxEntry> loadRecentEdited() {
        return this.readEntries(this.identity.getName(), RECENT_EDITED_ID);
    }

    public List<InboxEntry> loadRecentEdited(String userName) {
        return this.readEntries(userName, RECENT_EDITED_ID);
    }

    public List<InboxEntry> loadRecentOpened() {
        return this.readEntries(this.identity.getName(), RECENT_VIEWED_ID);
    }

    public List<InboxEntry> loadIncoming() {
        return this.readEntries(this.identity.getName(), INCOMING_ID);
    }

    public List<InboxEntry> loadIncoming(String userName) {
        return this.readEntries(userName, INCOMING_ID);
    }

    public List<InboxEntry> readEntries(String userName, String boxName) {
        Path path = this.userServices.buildPath(userName, INBOX, boxName);
        if (this.ioService.exists(path)) {
            String xml = this.ioService.readAllString(path);
            if (xml != null && !xml.equals("")) {
                return (List)this.getXStream().fromXML(xml);
            }
            return new ArrayList<InboxEntry>();
        }
        return new ArrayList<InboxEntry>();
    }

    public void recordOpeningEvent(@Observes ResourceOpenedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getPath();
        this.recordOpeningEvent(resourcePath.toURI(), resourcePath.getFileName().toString());
    }

    public synchronized void recordOpeningEvent(String itemPath, String itemName) {
        this.addToRecentOpened(itemPath, itemName);
        List<InboxEntry> unreadIncoming = this.removeAnyExisting(itemPath, this.loadIncoming());
        this.writeEntries(INCOMING_ID, unreadIncoming);
    }

    public void recordUserEditEvent(@Observes ResourceUpdatedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getPath();
        this.recordUserEditEvent(resourcePath.toURI(), resourcePath.getFileName().toString());
    }

    public synchronized void recordUserEditEvent(String itemPath, String itemName) {
        this.addToRecentEdited(itemPath, itemName);
        this.addToIncoming(itemPath, itemName, this.identity.getName(), "mailman");
        this.mailboxService.processOutgoing();
        this.mailboxService.wakeUp();
    }

    public void addToRecentEdited(String itemPath, String note) {
        this.addToInbox(RECENT_EDITED_ID, itemPath, note, this.identity.getName(), this.identity.getName());
    }

    public void addToRecentOpened(String itemPath, String note) {
        this.addToInbox(RECENT_VIEWED_ID, itemPath, note, this.identity.getName(), this.identity.getName());
    }

    public void addToIncoming(String itemPath, String note, String userFrom, String userName) {
        this.addToInbox(INCOMING_ID, itemPath, note, userFrom, userName);
    }

    private void addToInbox(String boxName, String itemPath, String note, String userFrom, String userName) {
        assert (boxName.equals(RECENT_EDITED_ID) || boxName.equals(RECENT_VIEWED_ID) || boxName.equals(INCOMING_ID));
        List<InboxEntry> entries = this.removeAnyExisting(itemPath, this.readEntries(userName, boxName));
        if (entries.size() >= 200) {
            entries.remove(0);
            entries.add(new InboxEntry(itemPath, note, userFrom));
        } else {
            entries.add(new InboxEntry(itemPath, note, userFrom));
        }
        this.writeEntries(boxName, entries);
    }

    private List<InboxEntry> removeAnyExisting(String itemPath, List<InboxEntry> inboxEntries) {
        Iterator<InboxEntry> it = inboxEntries.iterator();
        while (it.hasNext()) {
            InboxEntry e = it.next();
            if (!e.itemPath.equals(itemPath)) continue;
            it.remove();
            return inboxEntries;
        }
        return inboxEntries;
    }

    public void writeEntries(String boxName, List<InboxEntry> entries) {
        Path path = this.userServices.buildPath(INBOX, boxName);
        String entry = this.getXStream().toXML(entries);
        this.ioService.write(path, entry, new OpenOption[0]);
    }

    private XStream getXStream() {
        XStream xs = new XStream();
        xs.alias("inbox-entries", List.class);
        xs.alias("entry", InboxEntry.class);
        return xs;
    }

    public static class InboxEntry {
        public String from;
        public String itemPath;
        public String note;
        public long timestamp;

        public InboxEntry() {
        }

        public InboxEntry(String itemPath, String note, String userFrom) {
            this.itemPath = itemPath;
            this.note = note;
            this.timestamp = System.currentTimeMillis();
            this.from = userFrom;
        }
    }
}

