/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.client;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.inbox.client.resources.i18n.InboxConstants;
import org.guvnor.inbox.model.InboxPageRow;
import org.guvnor.inbox.service.InboxService;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Inbox")
public class InboxPresenter {
    public static final String RECENT_EDITED_ID = "recentEdited";
    public static final String RECENT_VIEWED_ID = "recentViewed";
    public static final String INCOMING_ID = "incoming";
    @Inject
    private View view;
    private String inboxName = "incoming";
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<InboxService> inboxService;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.inboxName = place.getParameter("inboxname", INCOMING_ID);
        this.view.init(this.inboxName, this.inboxService, this);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        if (INCOMING_ID.equals(this.inboxName)) {
            return InboxConstants.INSTANCE.incomingChanges();
        }
        if (RECENT_EDITED_ID.equals(this.inboxName)) {
            return InboxConstants.INSTANCE.recentlyEdited();
        }
        if (RECENT_VIEWED_ID.equals(this.inboxName)) {
            return InboxConstants.INSTANCE.recentlyOpened();
        }
        return "Incoming Changes";
    }

    public void open(InboxPageRow row) {
        Path path = row.getPath();
        if (path != null) {
            this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(path));
        }
    }

    public static interface View
    extends IsWidget {
        public void init(String var1, Caller<InboxService> var2, InboxPresenter var3);
    }
}

