/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.client.editor;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import org.guvnor.inbox.client.InboxPresenter;
import org.guvnor.inbox.client.editor.InboxView;
import org.guvnor.inbox.client.resources.i18n.InboxConstants;
import org.guvnor.inbox.client.resources.images.ImageResources;
import org.guvnor.inbox.model.InboxPageRequest;
import org.guvnor.inbox.model.InboxPageRow;
import org.guvnor.inbox.service.InboxService;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.ext.widgets.common.client.tables.ComparableImageResource;
import org.uberfire.ext.widgets.common.client.tables.ComparableImageResourceCell;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.paging.PageResponse;

public class InboxViewImpl
extends Composite
implements InboxView {
    private static final int PAGE_SIZE = 10;
    private InboxViewImplWidgetBinder uiBinder = (InboxViewImplWidgetBinder)GWT.create(InboxViewImplWidgetBinder.class);
    @UiField(provided=true)
    final PagedTable<InboxPageRow> table = new PagedTable(10);

    public InboxViewImpl(final Caller<InboxService> inboxService, final String inboxName, final InboxPresenter presenter) {
        Column<InboxPageRow, String> openColumn = new Column<InboxPageRow, String>((Cell)new ButtonCell()){

            public String getValue(InboxPageRow row) {
                return InboxConstants.INSTANCE.open();
            }
        };
        openColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<InboxPageRow, String>(){

            public void update(int index, InboxPageRow row, String value) {
                presenter.open(row);
            }
        });
        this.table.addColumn((Column)openColumn, InboxConstants.INSTANCE.open());
        Column<InboxPageRow, ComparableImageResource> formatColumn = new Column<InboxPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(InboxPageRow row) {
                return new ComparableImageResource(row.getFormat(), new Image(ImageResources.INSTANCE.fileIcon()));
            }
        };
        this.table.addColumn((Column)formatColumn, InboxConstants.INSTANCE.format());
        TextColumn<InboxPageRow> noteColumn = new TextColumn<InboxPageRow>(){

            public String getValue(InboxPageRow row) {
                return row.getNote();
            }
        };
        this.table.addColumn((Column)noteColumn, InboxConstants.INSTANCE.name());
        Column<InboxPageRow, Date> dateColumn = new Column<InboxPageRow, Date>((Cell)new DateCell((DateTimeFormat)com.google.gwt.i18n.client.DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(InboxPageRow row) {
                return row.getTimestamp();
            }
        };
        this.table.addColumn((Column)dateColumn, InboxConstants.INSTANCE.createdDate());
        this.table.setDataProvider((AbstractDataProvider)new AsyncDataProvider<InboxPageRow>(){

            protected void onRangeChanged(HasData<InboxPageRow> display) {
                InboxPageRequest request = new InboxPageRequest(inboxName, InboxViewImpl.this.table.dataGrid.getPageStart(), Integer.valueOf(10));
                ((InboxService)inboxService.call((RemoteCallback)new RemoteCallback<PageResponse<InboxPageRow>>(){

                    public void callback(PageResponse<InboxPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                })).loadInbox(request);
            }
        });
        Button refreshButton = new Button();
        refreshButton.setIcon(IconType.REFRESH);
        refreshButton.setTitle(InboxConstants.INSTANCE.refresh());
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                InboxViewImpl.this.table.refresh();
            }
        });
        this.table.getToolbar().add((Widget)refreshButton);
        this.initWidget((Widget)this.uiBinder.createAndBindUi(this));
    }

    static interface InboxViewImplWidgetBinder
    extends UiBinder<Widget, InboxViewImpl> {
    }
}

