/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.messageconsole.client.console.HyperLinkCell;
import org.guvnor.messageconsole.client.console.MessageConsoleService;
import org.guvnor.messageconsole.client.console.MessageConsoleServiceRow;
import org.guvnor.messageconsole.client.console.MessageConsoleView;
import org.guvnor.messageconsole.client.console.resources.MessageConsoleResources;
import org.guvnor.messageconsole.events.SystemMessage;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;

@ApplicationScoped
public class MessageConsoleViewImpl
extends Composite
implements MessageConsoleView {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private MessageConsoleService consoleService;
    protected final SimpleTable<MessageConsoleServiceRow> dataGrid = new SimpleTable();

    public MessageConsoleViewImpl() {
        this.addLevelColumn();
        this.addTextColumn();
        this.addFileNameColumn();
        this.addColumnColumn();
        this.addLineColumn();
        this.initWidget((Widget)this.dataGrid);
    }

    @PostConstruct
    public void setupDataDisplay() {
        this.consoleService.addDataDisplay((HasData<MessageConsoleServiceRow>)this.dataGrid);
    }

    private void addLineColumn() {
        Column<MessageConsoleServiceRow, String> lineColumn = new Column<MessageConsoleServiceRow, String>((Cell)new TextCell()){

            public String getValue(MessageConsoleServiceRow row) {
                return row != null ? Integer.toString(row.getMessageLine()) : null;
            }
        };
        this.dataGrid.addColumn((Column)lineColumn, MessageConsoleResources.CONSTANTS.Line());
        this.dataGrid.setColumnWidth((Column)lineColumn, 60.0, Style.Unit.PCT);
    }

    private void addColumnColumn() {
        Column<MessageConsoleServiceRow, String> column = new Column<MessageConsoleServiceRow, String>((Cell)new TextCell()){

            public String getValue(MessageConsoleServiceRow row) {
                return Integer.toString(row.getMessageColumn());
            }
        };
        this.dataGrid.addColumn((Column)column, MessageConsoleResources.CONSTANTS.Column());
        this.dataGrid.setColumnWidth((Column)column, 60.0, Style.Unit.PCT);
    }

    private void addTextColumn() {
        Column<MessageConsoleServiceRow, String> column = new Column<MessageConsoleServiceRow, String>((Cell)new TextCell()){

            public String getValue(MessageConsoleServiceRow row) {
                return row.getMessageText();
            }

            public void render(Cell.Context context, MessageConsoleServiceRow row, SafeHtmlBuilder sb) {
                String title = row.getMessageText();
                sb.append(MessageConsoleViewImpl.this.createDivStart(title));
                super.render(context, (Object)row, sb);
                sb.append(MessageConsoleViewImpl.this.createDivEnd());
            }
        };
        this.dataGrid.addColumn((Column)column, MessageConsoleResources.CONSTANTS.Text());
        this.dataGrid.setColumnWidth((Column)column, 60.0, Style.Unit.PCT);
    }

    private void addFileNameColumn() {
        Column<MessageConsoleServiceRow, HyperLinkCell.HyperLink> column = new Column<MessageConsoleServiceRow, HyperLinkCell.HyperLink>((Cell)new HyperLinkCell()){

            public HyperLinkCell.HyperLink getValue(MessageConsoleServiceRow row) {
                if (row.getMessagePath() != null) {
                    return HyperLinkCell.HyperLink.newLink(row.getMessagePath().getFileName());
                }
                return HyperLinkCell.HyperLink.newText("-");
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<MessageConsoleServiceRow, HyperLinkCell.HyperLink>(){

            public void update(int index, MessageConsoleServiceRow row, HyperLinkCell.HyperLink value) {
                if (row.getMessagePath() != null) {
                    MessageConsoleViewImpl.this.placeManager.goTo(row.getMessagePath());
                }
            }
        });
        this.dataGrid.addColumn((Column)column, MessageConsoleResources.CONSTANTS.FileName());
        this.dataGrid.setColumnWidth((Column)column, 60.0, Style.Unit.PCT);
    }

    private void addLevelColumn() {
        Column<MessageConsoleServiceRow, ImageResource> column = new Column<MessageConsoleServiceRow, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(MessageConsoleServiceRow row) {
                switch (row.getMessageLevel()) {
                    case ERROR: {
                        return MessageConsoleResources.INSTANCE.Error();
                    }
                    case WARNING: {
                        return MessageConsoleResources.INSTANCE.Warning();
                    }
                }
                return MessageConsoleResources.INSTANCE.Information();
            }

            public void render(Cell.Context context, MessageConsoleServiceRow row, SafeHtmlBuilder sb) {
                String title = MessageConsoleViewImpl.this.getLevelTitle(row.getMessageLevel());
                sb.append(MessageConsoleViewImpl.this.createDivStart(title));
                super.render(context, (Object)row, sb);
                sb.append(MessageConsoleViewImpl.this.createDivEnd());
            }
        };
        this.dataGrid.addColumn((Column)column, MessageConsoleResources.CONSTANTS.Level());
        this.dataGrid.setColumnWidth((Column)column, 60.0, Style.Unit.PCT);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    private String getLevelTitle(SystemMessage.Level level) {
        switch (level) {
            case ERROR: {
                return MessageConsoleResources.CONSTANTS.ErrorLevelTitle();
            }
            case WARNING: {
                return MessageConsoleResources.CONSTANTS.WarningLevelTitle();
            }
        }
        return MessageConsoleResources.CONSTANTS.InfoLevelTitle();
    }

    private SafeHtml createDivStart(String title) {
        return this.createDivStart(title, "");
    }

    private SafeHtml createDivStart(String title, String defaultValue) {
        if (title == null || "".equals(title)) {
            title = defaultValue;
        }
        return SafeHtmlUtils.fromTrustedString((String)("<div title=\"" + SafeHtmlUtils.htmlEscape((String)title.trim()) + "\">"));
    }

    private SafeHtml createDivEnd() {
        return SafeHtmlUtils.fromTrustedString((String)"</div>");
    }
}

