/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console.widget;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.messageconsole.client.console.resources.MessageConsoleResources;
import org.gwtbootstrap3.client.ui.html.Span;
import org.uberfire.client.views.pfly.icon.PatternFlyIconType;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;

public class MessageTableWidget<T>
extends Composite
implements HasData<T> {
    public static final int DEFAULT_PAGE_SIZE = 5;
    SimpleTable<T> dataGrid;

    public MessageTableWidget() {
        this.dataGrid = new SimpleTable();
        this.initWidget((Widget)this.dataGrid);
    }

    public MessageTableWidget(Mode mode) {
        if (mode == Mode.SIMPLE) {
            this.dataGrid = new SimpleTable();
        } else if (mode == Mode.PAGED) {
            this.dataGrid = new PagedTable(5);
            this.dataGrid.setHeight("165px");
            this.dataGrid.setAlwaysShowScrollBars(false);
        }
        this.initWidget((Widget)this.dataGrid);
    }

    public MessageTableWidget(SimpleTable dataGrid) {
        this.dataGrid = dataGrid;
        this.initWidget((Widget)dataGrid);
    }

    public void addLevelColumn(int pct, final ColumnExtractor<Level> extractor) {
        Column column = new Column<T, Level>((Cell)new IconCell()){

            public Level getValue(T row) {
                return (Level)extractor.getValue(row);
            }

            public void render(Cell.Context context, T row, SafeHtmlBuilder sb) {
                String title = MessageTableWidget.this.getLevelTitle((Level)extractor.getValue(row));
                sb.append(MessageTableWidget.this.createDivStart(title));
                super.render(context, row, sb);
                sb.append(MessageTableWidget.this.createDivEnd());
            }
        };
        this.dataGrid.addColumn(column, MessageConsoleResources.CONSTANTS.Level());
        this.dataGrid.setColumnWidth(column, (double)pct, Style.Unit.PCT);
    }

    public void addTextColumn(int pct, final ColumnExtractor<String> extractor) {
        Column column = new Column<T, String>((Cell)new TextCell()){

            public String getValue(T row) {
                return (String)extractor.getValue(row);
            }

            public void render(Cell.Context context, T row, SafeHtmlBuilder sb) {
                String title = (String)extractor.getValue(row);
                sb.append(MessageTableWidget.this.createDivStart(title));
                super.render(context, row, sb);
                sb.append(MessageTableWidget.this.createDivEnd());
            }
        };
        this.dataGrid.addColumn(column, MessageConsoleResources.CONSTANTS.Text());
        this.dataGrid.setColumnWidth(column, (double)pct, Style.Unit.PCT);
    }

    private String getLevelTitle(Level level) {
        switch (level) {
            case ERROR: {
                return MessageConsoleResources.CONSTANTS.ErrorLevelTitle();
            }
            case WARNING: {
                return MessageConsoleResources.CONSTANTS.WarningLevelTitle();
            }
        }
        return MessageConsoleResources.CONSTANTS.InfoLevelTitle();
    }

    public SafeHtml createDivStart(String title) {
        return this.createDivStart(title, "");
    }

    public SafeHtml createDivStart(String title, String defaultValue) {
        if (title == null || "".equals(title)) {
            title = defaultValue;
        }
        return SafeHtmlUtils.fromTrustedString((String)("<div title=\"" + SafeHtmlUtils.htmlEscape((String)title.trim()) + "\">"));
    }

    public SafeHtml createDivEnd() {
        return SafeHtmlUtils.fromTrustedString((String)"</div>");
    }

    public void setDataProvider(AbstractDataProvider<T> dataProvider) {
        if (this.dataGrid instanceof PagedTable) {
            ((PagedTable)this.dataGrid).setDataProvider(dataProvider);
        }
    }

    public final AbstractDataProvider<T> getDataProvider() {
        if (this.dataGrid instanceof PagedTable) {
            return ((PagedTable)this.dataGrid).getDataProvider();
        }
        return null;
    }

    public void setToolBarVisible(boolean visible) {
        this.dataGrid.setToolBarVisible(visible);
    }

    public ColumnSortList getColumnSortList() {
        return this.dataGrid.getColumnSortList();
    }

    public HasWidgets getToolbar() {
        return this.dataGrid.getToolbar();
    }

    public HasWidgets getRightToolbar() {
        return this.dataGrid.getRightToolbar();
    }

    public HasWidgets getRightActionsToolbar() {
        return this.dataGrid.getRightActionsToolbar();
    }

    public HasWidgets getLeftToolbar() {
        return this.dataGrid.getLeftToolbar();
    }

    public HasWidgets getCenterToolbar() {
        return this.dataGrid.getCenterToolbar();
    }

    public void setRowStyles(RowStyles<T> styles) {
        this.dataGrid.setRowStyles(styles);
    }

    public void setcolumnPickerButtonVisibe(boolean show) {
        this.dataGrid.setcolumnPickerButtonVisibe(show);
    }

    public void addColumn(Column<T, ?> lineColumn, String line) {
        this.dataGrid.addColumn(lineColumn, line);
    }

    public void setColumnWidth(Column<T, ?> lineColumn, int i, Style.Unit pct) {
        this.dataGrid.setColumnWidth(lineColumn, (double)i, pct);
    }

    public void setHeight(String height) {
        this.dataGrid.setHeight(height);
    }

    public void setPixelSize(int width, int height) {
        this.dataGrid.setPixelSize(width, height);
    }

    public void setSize(String width, String height) {
        this.dataGrid.setSize(width, height);
    }

    public void setWidth(String width) {
        this.dataGrid.setWidth(width);
    }

    public SelectionModel<? super T> getSelectionModel() {
        return this.dataGrid.getSelectionModel();
    }

    public T getVisibleItem(int indexOnPage) {
        return (T)this.dataGrid.getVisibleItem(indexOnPage);
    }

    public int getVisibleItemCount() {
        return this.dataGrid.getVisibleItemCount();
    }

    public Iterable<T> getVisibleItems() {
        return this.dataGrid.getVisibleItems();
    }

    public void setRowData(int start, List<? extends T> values) {
        this.dataGrid.setRowData(start, values);
    }

    public void setRowData(List<? extends T> values) {
        this.dataGrid.setRowData(values);
    }

    public void redraw() {
        this.dataGrid.redraw();
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.dataGrid.setSelectionModel(selectionModel);
    }

    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.dataGrid.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
    }

    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.dataGrid.addCellPreviewHandler(handler);
    }

    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.dataGrid.addRangeChangeHandler(handler);
    }

    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.dataGrid.addRowCountChangeHandler(handler);
    }

    public int getRowCount() {
        return this.dataGrid.getRowCount();
    }

    public Range getVisibleRange() {
        return this.dataGrid.getVisibleRange();
    }

    public boolean isRowCountExact() {
        return this.dataGrid.isRowCountExact();
    }

    public void setRowCount(int count) {
        this.dataGrid.setRowCount(count);
    }

    public void setRowCount(int count, boolean isExact) {
        this.dataGrid.setRowCount(count, isExact);
    }

    public void setVisibleRange(int start, int length) {
        this.dataGrid.setVisibleRange(length, length);
    }

    public void setVisibleRange(Range range) {
        this.dataGrid.setVisibleRange(range);
    }

    private class IconCell
    extends AbstractCell<Level> {
        private IconCell() {
            super(new String[0]);
        }

        public void render(Cell.Context context, Level level, SafeHtmlBuilder sb) {
            Span icon = (Span)GWT.create(Span.class);
            icon.addStyleName("glyphicon");
            icon.addStyleName(this.getIconClass(level));
            sb.appendHtmlConstant(icon.getElement().getString());
        }

        private String getIconClass(Level level) {
            switch (level) {
                case ERROR: {
                    return PatternFlyIconType.ERROR_CIRCLE_O.getCssName();
                }
                case WARNING: {
                    return PatternFlyIconType.WARNING_TRIANGLE_O.getCssName();
                }
            }
            return PatternFlyIconType.INFO.getCssName();
        }
    }

    public static interface ColumnExtractor<V> {
        public V getValue(Object var1);
    }

    public static enum Mode {
        SIMPLE,
        PAGED;

    }
}

