/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.messageconsole.client.console.MessageConsoleViewImpl;
import org.guvnor.messageconsole.client.console.resources.MessageConsoleResources;
import org.guvnor.messageconsole.events.MessageUtils;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.workbench.common.screens.messageconsole.MessageConsole")
public class MessageConsoleScreen
implements RefreshMenuBuilder.SupportsRefresh {
    @Inject
    private Caller<BuildService> buildService;
    @Inject
    private Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;
    @Inject
    private MessageConsoleViewImpl view;
    private Project project;
    private Menus menus;

    public MessageConsoleScreen() {
        this.makeMenuBar();
    }

    public void onRefresh() {
        this.view.showBusyIndicator(MessageConsoleResources.CONSTANTS.Refreshing());
        ((BuildService)this.buildService.call((RemoteCallback)new RemoteCallback<BuildResults>(){

            public void callback(BuildResults results) {
                PublishBatchMessagesEvent batchMessages = new PublishBatchMessagesEvent();
                batchMessages.setCleanExisting(true);
                batchMessages.setMessageType("BuildSystem");
                if (results.getMessages() != null) {
                    for (BuildMessage buildMessage : results.getMessages()) {
                        batchMessages.getMessagesToPublish().add(MessageUtils.convert((BuildMessage)buildMessage));
                    }
                }
                MessageConsoleScreen.this.publishBatchMessagesEvent.fire((Object)batchMessages);
                MessageConsoleScreen.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).build(this.project);
    }

    private void makeMenuBar() {
        this.menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)MessageConsoleResources.CONSTANTS.ClearMessageConsole()).respondsWith(new Command(){

            public void execute() {
                PublishBatchMessagesEvent batchMessages = new PublishBatchMessagesEvent();
                batchMessages.setCleanExisting(true);
                batchMessages.setMessagesToPublish(new ArrayList());
                MessageConsoleScreen.this.publishBatchMessagesEvent.fire((Object)batchMessages);
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public void selectedProjectChanged(@Observes ProjectContextChangeEvent event) {
        this.project = event.getProject();
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(this.project != null);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.SOUTH;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return MessageConsoleResources.CONSTANTS.MessageConsole();
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

