/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.messageconsole.client.console.HyperLinkCell;
import org.guvnor.messageconsole.client.console.MessageConsoleService;
import org.guvnor.messageconsole.client.console.MessageConsoleServiceRow;
import org.guvnor.messageconsole.client.console.MessageConsoleView;
import org.guvnor.messageconsole.client.console.resources.MessageConsoleResources;
import org.guvnor.messageconsole.client.console.widget.MessageTableWidget;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@ApplicationScoped
public class MessageConsoleViewImpl
extends Composite
implements MessageConsoleView {
    private MessageConsoleViewImplWidgetBinder uiBinder = (MessageConsoleViewImplWidgetBinder)GWT.create(MessageConsoleViewImplWidgetBinder.class);
    @Inject
    private PlaceManager placeManager;
    @Inject
    private MessageConsoleService consoleService;
    @UiField(provided=true)
    protected final MessageTableWidget<MessageConsoleServiceRow> dataGrid = new MessageTableWidget();

    public MessageConsoleViewImpl() {
        this.dataGrid.addLevelColumn(75, new MessageTableWidget.ColumnExtractor<Level>(){

            @Override
            public Level getValue(Object row) {
                return ((MessageConsoleServiceRow)((Object)row)).getMessageLevel();
            }
        });
        this.dataGrid.addTextColumn(100, new MessageTableWidget.ColumnExtractor<String>(){

            @Override
            public String getValue(Object row) {
                return ((MessageConsoleServiceRow)((Object)row)).getMessageText();
            }
        });
        this.addFileNameColumn();
        this.addColumnColumn();
        this.addLineColumn();
        this.initWidget((Widget)this.uiBinder.createAndBindUi(this));
    }

    @PostConstruct
    public void setupDataDisplay() {
        this.consoleService.addDataDisplay(this.dataGrid);
    }

    private void addLineColumn() {
        Column<MessageConsoleServiceRow, String> lineColumn = new Column<MessageConsoleServiceRow, String>((Cell)new TextCell()){

            public String getValue(MessageConsoleServiceRow row) {
                return row != null ? Integer.toString(row.getMessageLine()) : null;
            }
        };
        this.dataGrid.addColumn(lineColumn, MessageConsoleResources.CONSTANTS.Line());
        this.dataGrid.setColumnWidth(lineColumn, 75, Style.Unit.PX);
    }

    private void addColumnColumn() {
        Column<MessageConsoleServiceRow, String> column = new Column<MessageConsoleServiceRow, String>((Cell)new TextCell()){

            public String getValue(MessageConsoleServiceRow row) {
                return Integer.toString(row.getMessageColumn());
            }
        };
        this.dataGrid.addColumn(column, MessageConsoleResources.CONSTANTS.Column());
        this.dataGrid.setColumnWidth(column, 75, Style.Unit.PX);
    }

    private void addFileNameColumn() {
        Column<MessageConsoleServiceRow, HyperLinkCell.HyperLink> column = new Column<MessageConsoleServiceRow, HyperLinkCell.HyperLink>((Cell)new HyperLinkCell()){

            public HyperLinkCell.HyperLink getValue(MessageConsoleServiceRow row) {
                if (row.getMessagePath() != null) {
                    return HyperLinkCell.HyperLink.newLink(row.getMessagePath().getFileName());
                }
                return HyperLinkCell.HyperLink.newText("-");
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<MessageConsoleServiceRow, HyperLinkCell.HyperLink>(){

            public void update(int index, MessageConsoleServiceRow row, HyperLinkCell.HyperLink value) {
                if (row.getMessagePath() != null) {
                    MessageConsoleViewImpl.this.placeManager.goTo(row.getMessagePath());
                }
            }
        });
        this.dataGrid.addColumn(column, MessageConsoleResources.CONSTANTS.FileName());
        this.dataGrid.setColumnWidth(column, 180, Style.Unit.PX);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    static interface MessageConsoleViewImplWidgetBinder
    extends UiBinder<Widget, MessageConsoleViewImpl> {
    }
}

