/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.drools.core.util.AbstractXStreamConverter;
import org.guvnor.common.services.project.model.ClockTypeOption;
import org.guvnor.common.services.project.model.KSessionModel;
import org.guvnor.common.services.project.model.ListenerModel;
import org.guvnor.common.services.project.model.WorkItemHandlerModel;

public class KSessionConverter
extends AbstractXStreamConverter {
    public KSessionConverter() {
        super(KSessionModel.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        KSessionModel kSession = (KSessionModel)value;
        writer.addAttribute("name", kSession.getName());
        writer.addAttribute("type", kSession.getType());
        writer.addAttribute("default", Boolean.toString(kSession.isDefault()));
        if (kSession.getClockType() != null) {
            writer.addAttribute("clockType", kSession.getClockType().getClockTypeAsString());
        }
        if (kSession.getScope() != null) {
            writer.addAttribute("scope", kSession.getScope().toString());
        }
        this.writeObjectList(writer, context, "workItemHandlers", "workItemHandler", kSession.getWorkItemHandelerModels());
        if (!kSession.getListenerModels().isEmpty()) {
            writer.startNode("listeners");
            for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.WORKING_MEMORY_EVENT_LISTENER)) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.AGENDA_EVENT_LISTENER)) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.PROCESS_EVENT_LISTENER)) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        String scope;
        final KSessionModel kSession = new KSessionModel();
        kSession.setName(reader.getAttribute("name"));
        kSession.setDefault("true".equals(reader.getAttribute("default")));
        String kSessionType = reader.getAttribute("type");
        kSession.setType(kSessionType != null ? kSessionType : "stateful");
        String clockType = reader.getAttribute("clockType");
        if (clockType != null) {
            kSession.setClockType(ClockTypeOption.get((String)clockType));
        }
        if ((scope = reader.getAttribute("scope")) != null) {
            kSession.setScope(scope);
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                block3: {
                    block2: {
                        if (!"listeners".equals(name)) break block2;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            String nodeName = reader.getNodeName();
                            ListenerModel listener = (ListenerModel)KSessionConverter.this.readObject(reader, context, ListenerModel.class);
                            listener.setKSession(kSession);
                            listener.setKind(ListenerModel.Kind.fromString((String)nodeName));
                            kSession.addListenerModel(listener);
                            reader.moveUp();
                        }
                        break block3;
                    }
                    if (!"workItemHandlers".equals(name)) break block3;
                    List wihs = KSessionConverter.this.readObjectList(reader, context, WorkItemHandlerModel.class);
                    for (WorkItemHandlerModel wih : wihs) {
                        wih.setKSession(kSession);
                        kSession.addWorkItemHandelerModel(wih);
                    }
                }
            }
        });
        return kSession;
    }
}

