/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Repository;

@Dependent
public class POMContentHandler {
    public String toString(POM pomModel) throws IOException {
        return this.toString(pomModel, new Model());
    }

    private String toString(POM pom, Model model) throws IOException {
        model.setGroupId(pom.getGav().getGroupId());
        model.setArtifactId(pom.getGav().getArtifactId());
        model.setVersion(pom.getGav().getVersion());
        model.setModelVersion(pom.getModelVersion());
        for (Repository repository : pom.getRepositories()) {
            for (org.apache.maven.model.Repository repo : model.getRepositories()) {
                if (repo.getUrl().equals(repository.getUrl())) continue;
                model.addRepository(this.fromClientModelToPom(repository));
            }
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (org.guvnor.common.services.project.model.Dependency dependency : pom.getDependencies()) {
            dependencies.add(this.fromClientModelToPom(dependency));
        }
        model.setDependencies(dependencies);
        StringWriter stringWriter = new StringWriter();
        new MavenXpp3Writer().write((Writer)stringWriter, model);
        return stringWriter.toString();
    }

    public String toString(POM gavModel, String originalPomAsText) throws IOException, XmlPullParserException {
        return this.toString(gavModel, new MavenXpp3Reader().read((Reader)new StringReader(originalPomAsText)));
    }

    private org.apache.maven.model.Repository fromClientModelToPom(Repository from) {
        org.apache.maven.model.Repository to = new org.apache.maven.model.Repository();
        to.setId(from.getId());
        to.setName(from.getName());
        to.setUrl(from.getUrl());
        return to;
    }

    public POM toModel(String pomAsString) throws IOException, XmlPullParserException {
        Model model = new MavenXpp3Reader().read((Reader)new StringReader(pomAsString));
        POM gavModel = new POM(new GAV(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        for (org.apache.maven.model.Repository repository : model.getRepositories()) {
            gavModel.addRepository(this.fromPomModelToClientModel(repository));
        }
        for (Dependency dependency : model.getDependencies()) {
            gavModel.getDependencies().add(this.fromPomModelToClientModel(dependency));
        }
        return gavModel;
    }

    private Repository fromPomModelToClientModel(org.apache.maven.model.Repository from) {
        Repository to = new Repository();
        to.setId(from.getId());
        to.setName(from.getName());
        to.setUrl(from.getUrl());
        return to;
    }

    private org.guvnor.common.services.project.model.Dependency fromPomModelToClientModel(Dependency from) {
        org.guvnor.common.services.project.model.Dependency dependency = new org.guvnor.common.services.project.model.Dependency();
        dependency.setArtifactId(from.getArtifactId());
        dependency.setGroupId(from.getGroupId());
        dependency.setVersion(from.getVersion());
        return dependency;
    }

    private Dependency fromClientModelToPom(org.guvnor.common.services.project.model.Dependency from) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(from.getArtifactId());
        dependency.setGroupId(from.getGroupId());
        dependency.setVersion(from.getVersion());
        return dependency;
    }
}

