/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.POMContentHandler;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Repository;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class POMServiceImpl
implements POMService {
    private IOService ioService;
    private Paths paths;
    private POMContentHandler pomContentHandler;
    private M2RepoService m2RepoService;
    private MetadataService metadataService;
    private Identity identity;
    private SessionInfo sessionInfo;

    public POMServiceImpl() {
    }

    @Inject
    public POMServiceImpl(@Named(value="ioStrategy") IOService ioService, Paths paths, POMContentHandler pomContentHandler, M2RepoService m2RepoService, MetadataService metadataService, Identity identity, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.paths = paths;
        this.pomContentHandler = pomContentHandler;
        this.m2RepoService = m2RepoService;
        this.metadataService = metadataService;
        this.identity = identity;
        this.sessionInfo = sessionInfo;
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path projectRoot, String baseURL, POM pomModel) {
        Path pathToPOMXML = null;
        try {
            Repository repository = new Repository();
            repository.setId("guvnor-m2-repo");
            repository.setName("Guvnor M2 Repo");
            repository.setUrl(this.m2RepoService.getRepositoryURL(baseURL));
            pomModel.addRepository(repository);
            Path nioRoot = this.paths.convert(projectRoot);
            pathToPOMXML = nioRoot.resolve("pom.xml");
            this.ioService.createFile(pathToPOMXML, new FileAttribute[0]);
            this.ioService.write(pathToPOMXML, this.pomContentHandler.toString(pomModel), new OpenOption[0]);
            return this.paths.convert(pathToPOMXML);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public POM load(org.uberfire.backend.vfs.Path path) {
        try {
            return this.pomContentHandler.toModel(this.loadPomXMLString(path));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String loadPomXMLString(org.uberfire.backend.vfs.Path path) {
        Path nioPath = this.paths.convert(path);
        return this.ioService.readAllString(nioPath);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata, String comment) {
        try {
            if (metadata == null) {
                this.ioService.write(this.paths.convert(path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), new OpenOption[]{this.makeCommentedOption(comment)});
            } else {
                this.ioService.write(this.paths.convert(path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            }
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        return new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
    }
}

