/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.drools.workbench.models.datamodel.imports.Import;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.LinkedMetaInfFolderFilter;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.backend.server.utils.IdentifierUtils;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.KModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.PackageAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.workingset.client.model.WorkingSetSettings;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class ProjectServiceImpl
implements ProjectService {
    private static final String SOURCE_FILENAME = "src";
    private static final String POM_PATH = "pom.xml";
    private static final String PROJECT_IMPORTS_PATH = "project.imports";
    private static final String KMODULE_PATH = "src/main/resources/META-INF/kmodule.xml";
    private static final String PROJECT_CATEGORIES_PATH = "categories.xml";
    private static final String MAIN_SRC_PATH = "src/main/java";
    private static final String TEST_SRC_PATH = "src/test/java";
    private static final String MAIN_RESOURCES_PATH = "src/main/resources";
    private static final String TEST_RESOURCES_PATH = "src/test/resources";
    private static String[] sourcePaths = new String[]{"src/main/java", "src/main/resources", "src/test/java", "src/test/resources"};
    private IOService ioService;
    private POMService pomService;
    private KModuleService kModuleService;
    private MetadataService metadataService;
    private ProjectConfigurationContentHandler projectConfigurationContentHandler;
    private ConfigurationService configurationService;
    private ConfigurationFactory configurationFactory;
    private Event<NewProjectEvent> newProjectEvent;
    private Event<NewPackageEvent> newPackageEvent;
    private Event<RenameProjectEvent> renameProjectEvent;
    private Event<DeleteProjectEvent> deleteProjectEvent;
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache;
    private Identity identity;
    private SessionInfo sessionInfo;

    public ProjectServiceImpl() {
    }

    @Inject
    public ProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, POMService pomService, KModuleService kModuleService, MetadataService metadataService, ProjectConfigurationContentHandler projectConfigurationContentHandler, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Event<RenameProjectEvent> renameProjectEvent, Event<DeleteProjectEvent> deleteProjectEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache, Identity identity, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.kModuleService = kModuleService;
        this.metadataService = metadataService;
        this.projectConfigurationContentHandler = projectConfigurationContentHandler;
        this.configurationService = configurationService;
        this.configurationFactory = configurationFactory;
        this.newProjectEvent = newProjectEvent;
        this.newPackageEvent = newPackageEvent;
        this.renameProjectEvent = renameProjectEvent;
        this.deleteProjectEvent = deleteProjectEvent;
        this.invalidateDMOCache = invalidateDMOCache;
        this.identity = identity;
        this.sessionInfo = sessionInfo;
    }

    public WorkingSetSettings loadWorkingSetConfig(org.uberfire.backend.vfs.Path project) {
        return new WorkingSetSettings();
    }

    public Project resolveProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                path = path.getParent();
            }
            if (this.hasPom(path) && this.hasKModule(path)) {
                return this.makeProject(path);
            }
            while (path.getNameCount() > 0 && !path.getFileName().toString().equals(SOURCE_FILENAME)) {
                path = path.getParent();
            }
            if (path.getNameCount() == 0) {
                return null;
            }
            if ((path = path.getParent()).getNameCount() == 0 || path == null) {
                return null;
            }
            if (!this.hasPom(path)) {
                return null;
            }
            if (!this.hasKModule(path)) {
                return null;
            }
            return this.makeProject(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Project makeProject(Path nioProjectRootPath) {
        ConfigItem roles;
        org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)nioProjectRootPath);
        Project project = this.simpleProjectInstance(nioProjectRootPath);
        ConfigGroup projectConfiguration = this.findProjectConfig(projectRootPath);
        if (projectConfiguration != null && (roles = projectConfiguration.getConfigItem("security:roles")) != null) {
            for (String role : (List)roles.getValue()) {
                project.getRoles().add(role);
            }
        }
        return project;
    }

    public Project simpleProjectInstance(Path nioProjectRootPath) {
        org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)nioProjectRootPath);
        return new Project(projectRootPath, Paths.convert((Path)nioProjectRootPath.resolve(POM_PATH)), Paths.convert((Path)nioProjectRootPath.resolve(KMODULE_PATH)), Paths.convert((Path)nioProjectRootPath.resolve(PROJECT_IMPORTS_PATH)), projectRootPath.getFileName());
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Project project = this.resolveProject(resource);
            if (project == null) {
                return null;
            }
            if (this.isPom(resource) || this.isKModule(resource)) {
                return null;
            }
            return this.makePackage(project, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Set<Package> resolvePackages(Project project) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (project == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        for (String src : sourcePaths) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath, true, true, true));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : sourcePaths) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.resolvePackage(Paths.convert((Path)nioPackagePath)));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    public Set<Package> resolvePackages(Package pkg) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (pkg == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path projectRoot = pkg.getProjectRootPath();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        for (String src : sourcePaths) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src).resolve(this.resolvePkgName(pkg.getCaption()));
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath, false, true, false));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : sourcePaths) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.resolvePackage(Paths.convert((Path)nioPackagePath)));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    public Package resolveDefaultPackage(Project project) {
        HashSet<String> packageNames = new HashSet<String>();
        if (project == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        for (String src : sourcePaths) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath, true, true, false));
        }
        HashSet resolvedPackages = new HashSet();
        for (String packagePathSuffix : packageNames) {
            for (String src : sourcePaths) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                return this.resolvePackage(Paths.convert((Path)nioPackagePath));
            }
        }
        return null;
    }

    public Package resolveParentPackage(Package pkg) {
        HashSet<String> packageNames = new HashSet<String>();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getProjectRootPath());
        packageNames.addAll(this.getPackageNames(nioProjectRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainSrcPath()).getParent(), true, false, false));
        for (String packagePathSuffix : packageNames) {
            for (String src : sourcePaths) {
                if (packagePathSuffix == null) {
                    return null;
                }
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) continue;
                return this.resolvePackage(Paths.convert((Path)nioPackagePath));
            }
        }
        return null;
    }

    private String resolvePkgName(String caption) {
        if (caption.equals("<default>")) {
            return "";
        }
        return caption.replaceAll("\\.", "/");
    }

    private Set<String> getPackageNames(Path nioProjectRootPath, Path nioPackageSrcPath, boolean includeDefault, boolean includeChild, boolean recursive) {
        HashSet<String> packageNames = new HashSet<String>();
        if (!Files.exists((Path)nioPackageSrcPath, (LinkOption[])new LinkOption[0])) {
            return packageNames;
        }
        if (includeDefault || recursive) {
            packageNames.add(this.getPackagePathSuffix(nioProjectRootPath, nioPackageSrcPath));
        }
        if (!includeChild) {
            return packageNames;
        }
        LinkedMetaInfFolderFilter metaDataFileFilter = new LinkedMetaInfFolderFilter();
        DirectoryStream nioChildPackageSrcPaths = this.ioService.newDirectoryStream(nioPackageSrcPath, (DirectoryStream.Filter)metaDataFileFilter);
        for (Path nioChildPackageSrcPath : nioChildPackageSrcPaths) {
            if (!Files.isDirectory((Path)nioChildPackageSrcPath, (LinkOption[])new LinkOption[0])) continue;
            if (recursive) {
                packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioChildPackageSrcPath, includeDefault, includeChild, recursive));
                continue;
            }
            packageNames.add(this.getPackagePathSuffix(nioProjectRootPath, nioChildPackageSrcPath));
        }
        return packageNames;
    }

    private String getPackagePathSuffix(Path nioProjectRootPath, Path nioPackagePath) {
        Path nioMainSrcPath = nioProjectRootPath.resolve(MAIN_SRC_PATH);
        Path nioTestSrcPath = nioProjectRootPath.resolve(TEST_SRC_PATH);
        Path nioMainResourcesPath = nioProjectRootPath.resolve(MAIN_RESOURCES_PATH);
        Path nioTestResourcesPath = nioProjectRootPath.resolve(TEST_RESOURCES_PATH);
        String packageName = null;
        Path packagePath = null;
        if (nioPackagePath.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        }
        return packageName;
    }

    private Package makePackage(Project project, org.uberfire.backend.vfs.Path resource) {
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRoot = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        Path nioMainSrcPath = nioProjectRoot.resolve(MAIN_SRC_PATH);
        Path nioTestSrcPath = nioProjectRoot.resolve(TEST_SRC_PATH);
        Path nioMainResourcesPath = nioProjectRoot.resolve(MAIN_RESOURCES_PATH);
        Path nioTestResourcesPath = nioProjectRoot.resolve(TEST_RESOURCES_PATH);
        Path nioResource = Paths.convert((org.uberfire.backend.vfs.Path)resource);
        if (Files.isRegularFile((Path)nioResource, (LinkOption[])new LinkOption[0])) {
            nioResource = nioResource.getParent();
        }
        String packageName = null;
        Path packagePath = null;
        if (nioResource.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        }
        if (packageName == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path mainSrcPath = Paths.convert((Path)nioMainSrcPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path testSrcPath = Paths.convert((Path)nioTestSrcPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path mainResourcesPath = Paths.convert((Path)nioMainResourcesPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path testResourcesPath = Paths.convert((Path)nioTestResourcesPath.resolve(packagePath));
        String displayName = this.getPackageDisplayName(packageName);
        Package pkg = new Package(project.getRootPath(), mainSrcPath, testSrcPath, mainResourcesPath, testResourcesPath, packageName, displayName, this.getPackageRelativeCaption(displayName, resource.getFileName()));
        return pkg;
    }

    private String getPackageDisplayName(String packageName) {
        return packageName.isEmpty() ? "<default>" : packageName;
    }

    private String getPackageRelativeCaption(String displayName, String relativeName) {
        return displayName.equals("<default>") ? "<default>" : relativeName;
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            Project project = this.resolveProject(resource);
            if (project == null) {
                return false;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path pomFilePath = Paths.convert((org.uberfire.backend.vfs.Path)project.getPomXMLPath());
            return path.startsWith(pomFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean isKModule(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            Project project = this.resolveProject(resource);
            if (project == null) {
                return false;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path kmoduleFilePath = Paths.convert((org.uberfire.backend.vfs.Path)project.getKModuleXMLPath());
            return path.startsWith(kmoduleFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Project newProject(Repository repository, String projectName, POM pom, String baseUrl) {
        try {
            org.uberfire.backend.vfs.Path fsRoot = repository.getRoot();
            org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)fsRoot).resolve(projectName));
            this.kModuleService.setUpKModuleStructure(projectRootPath);
            this.pomService.create(projectRootPath, baseUrl, pom);
            org.uberfire.backend.vfs.Path projectConfigPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath).resolve(PROJECT_IMPORTS_PATH));
            this.ioService.createFile(Paths.convert((org.uberfire.backend.vfs.Path)projectConfigPath), new FileAttribute[0]);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)projectConfigPath), this.projectConfigurationContentHandler.toString(this.createProjectImports()), new OpenOption[0]);
            Project project = this.resolveProject(projectRootPath);
            this.newProjectEvent.fire((Object)new NewProjectEvent(project));
            Object[] legalJavaGroupId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier(pom.getGav().getGroupId().split("\\.", -1));
            Object[] legalJavaArtifactId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier(pom.getGav().getArtifactId().split("\\.", -1));
            String defaultWorkspacePath = StringUtils.join((Object[])legalJavaGroupId, (String)"/") + "/" + StringUtils.join((Object[])legalJavaArtifactId, (String)"/");
            org.uberfire.backend.vfs.Path defaultPackagePath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath).resolve(MAIN_RESOURCES_PATH));
            Package defaultPackage = this.resolvePackage(defaultPackagePath);
            Package defaultWorkspacePackage = this.doNewPackage(defaultPackage, defaultWorkspacePath);
            this.newPackageEvent.fire((Object)new NewPackageEvent(defaultWorkspacePackage));
            return project;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private ProjectImports createProjectImports() {
        ProjectImports imports = new ProjectImports();
        imports.getImports().addImport(new Import("java.lang.Number"));
        return imports;
    }

    public Package newPackage(Package parentPackage, String packageName) {
        try {
            Package newPackage = this.doNewPackage(parentPackage, packageName);
            this.newPackageEvent.fire((Object)new NewPackageEvent(newPackage));
            return newPackage;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Package doNewPackage(Package parentPackage, String packageName) {
        Path nioTestResourcesPackagePath;
        Path nioMainResourcesPackagePath;
        Path nioTestSrcPackagePath;
        String newPackageName = packageName.toLowerCase();
        if (newPackageName.contains(".")) {
            newPackageName = newPackageName.replace(".", "/");
        }
        org.uberfire.backend.vfs.Path mainSrcPath = parentPackage.getPackageMainSrcPath();
        org.uberfire.backend.vfs.Path testSrcPath = parentPackage.getPackageTestSrcPath();
        org.uberfire.backend.vfs.Path mainResourcesPath = parentPackage.getPackageMainResourcesPath();
        org.uberfire.backend.vfs.Path testResourcesPath = parentPackage.getPackageTestResourcesPath();
        org.uberfire.backend.vfs.Path pkgPath = null;
        Path nioMainSrcPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)mainSrcPath).resolve(newPackageName);
        if (!Files.exists((Path)nioMainSrcPackagePath, (LinkOption[])new LinkOption[0])) {
            pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioMainSrcPackagePath, new FileAttribute[0]));
        }
        if (!Files.exists((Path)(nioTestSrcPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)testSrcPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
            pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioTestSrcPackagePath, new FileAttribute[0]));
        }
        if (!Files.exists((Path)(nioMainResourcesPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)mainResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
            pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioMainResourcesPackagePath, new FileAttribute[0]));
        }
        if (!Files.exists((Path)(nioTestResourcesPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)testResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
            pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioTestResourcesPackagePath, new FileAttribute[0]));
        }
        if (pkgPath == null) {
            throw new PackageAlreadyExistsException(packageName);
        }
        Package newPackage = this.resolvePackage(pkgPath);
        return newPackage;
    }

    private boolean hasPom(Path path) {
        Path pomPath = path.resolve(POM_PATH);
        return Files.exists((Path)pomPath, (LinkOption[])new LinkOption[0]);
    }

    private boolean hasKModule(Path path) {
        Path kmodulePath = path.resolve(KMODULE_PATH);
        return Files.exists((Path)kmodulePath, (LinkOption[])new LinkOption[0]);
    }

    public ProjectImports load(org.uberfire.backend.vfs.Path path) {
        String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
        return this.projectConfigurationContentHandler.toModel(content);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ProjectImports projectImports, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.projectConfigurationContentHandler.toString(projectImports), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }

    public void addRole(Project project, String role) {
        ConfigGroup thisProjectConfig = this.findProjectConfig(project.getRootPath());
        if (thisProjectConfig == null) {
            thisProjectConfig = this.configurationFactory.newConfigGroup(ConfigType.PROJECT, project.getRootPath().toURI(), "Project '" + project.getProjectName() + "' configuration");
            thisProjectConfig.addConfigItem(this.configurationFactory.newConfigItem("security:roles", new ArrayList()));
            this.configurationService.addConfiguration(thisProjectConfig);
        }
        if (thisProjectConfig == null) {
            throw new IllegalArgumentException("Project " + project.getProjectName() + " not found");
        }
        ConfigItem roles = thisProjectConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).add(role);
        this.configurationService.updateConfiguration(thisProjectConfig);
    }

    public void removeRole(Project project, String role) {
        ConfigGroup thisProjectConfig = this.findProjectConfig(project.getRootPath());
        if (thisProjectConfig == null) {
            throw new IllegalArgumentException("Project " + project.getProjectName() + " not found");
        }
        ConfigItem roles = thisProjectConfig.getConfigItem("security:roles");
        ((List)roles.getValue()).remove(role);
        this.configurationService.updateConfiguration(thisProjectConfig);
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path pathToPomXML, String newName, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Path newProjectPath = projectDirectory.resolveSibling(newName);
            POM content = (POM)this.pomService.load(pathToPomXML);
            if (newProjectPath.equals(projectDirectory)) {
                return pathToPomXML;
            }
            if (this.ioService.exists(newProjectPath)) {
                throw new FileAlreadyExistsException(newProjectPath.toString());
            }
            org.uberfire.backend.vfs.Path oldProjectDir = Paths.convert((Path)projectDirectory);
            Project oldProject = this.resolveProject(oldProjectDir);
            content.setName(newName);
            org.uberfire.backend.vfs.Path newPathToPomXML = Paths.convert((Path)newProjectPath.resolve(POM_PATH));
            this.ioService.startBatch(new Option[0]);
            this.ioService.move(projectDirectory, newProjectPath, new CopyOption[]{this.makeCommentedOption(comment)});
            this.pomService.save(newPathToPomXML, (Object)content, null, comment);
            this.ioService.endBatch(new Option[0]);
            Project newProject = this.resolveProject(Paths.convert((Path)newProjectPath));
            this.invalidateDMOCache.fire((Object)new InvalidateDMOProjectCacheEvent(this.sessionInfo, oldProject, oldProjectDir));
            this.renameProjectEvent.fire((Object)new RenameProjectEvent(oldProject, newProject));
            return newPathToPomXML;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path pathToPomXML, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Project project2Delete = this.resolveProject(Paths.convert((Path)projectDirectory));
            this.ioService.delete(projectDirectory, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES, new CommentedOption(this.sessionInfo.getId(), this.identity.getName(), null, comment)});
            this.deleteProjectEvent.fire((Object)new DeleteProjectEvent(project2Delete));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void copy(org.uberfire.backend.vfs.Path pathToPomXML, String newName, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Path newProjectPath = projectDirectory.resolveSibling(newName);
            POM content = (POM)this.pomService.load(pathToPomXML);
            if (newProjectPath.equals(projectDirectory)) {
                return;
            }
            if (this.ioService.exists(newProjectPath)) {
                throw new FileAlreadyExistsException(newProjectPath.toString());
            }
            content.setName(newName);
            org.uberfire.backend.vfs.Path newPathToPomXML = Paths.convert((Path)newProjectPath.resolve(POM_PATH));
            this.ioService.startBatch(new Option[0]);
            this.ioService.copy(projectDirectory, newProjectPath, new CopyOption[]{this.makeCommentedOption(comment)});
            this.pomService.save(newPathToPomXML, (Object)content, null, comment);
            this.ioService.endBatch(new Option[0]);
            Project newProject = this.resolveProject(Paths.convert((Path)newProjectPath));
            this.newProjectEvent.fire((Object)new NewProjectEvent(newProject));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected ConfigGroup findProjectConfig(org.uberfire.backend.vfs.Path projectRoot) {
        List groups = this.configurationService.getConfiguration(ConfigType.PROJECT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(projectRoot.toURI())) continue;
                return groupConfig;
            }
        }
        return null;
    }
}

