/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.POMContentHandler;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Repository;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.data.Pair;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class POMServiceImpl
implements POMService {
    private IOService ioService;
    private POMContentHandler pomContentHandler;
    private M2RepoService m2RepoService;
    private MetadataService metadataService;
    @Inject
    private CommentedOptionFactory optionsFactory;
    private SessionInfo sessionInfo;

    public POMServiceImpl() {
    }

    @Inject
    public POMServiceImpl(@Named(value="ioStrategy") IOService ioService, POMContentHandler pomContentHandler, M2RepoService m2RepoService, MetadataService metadataService, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.pomContentHandler = pomContentHandler;
        this.m2RepoService = m2RepoService;
        this.metadataService = metadataService;
        this.sessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path projectRoot, String baseURL, POM pomModel) {
        Path pathToPOMXML = null;
        try {
            Repository repository = new Repository();
            repository.setId("guvnor-m2-repo");
            repository.setName("Guvnor M2 Repo");
            repository.setUrl(this.m2RepoService.getRepositoryURL(baseURL));
            pomModel.addRepository(repository);
            Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
            pathToPOMXML = nioRoot.resolve("pom.xml");
            if (this.ioService.exists(pathToPOMXML)) {
                throw new FileAlreadyExistsException(pathToPOMXML.toString());
            }
            this.ioService.write(pathToPOMXML, this.pomContentHandler.toString(pomModel), new OpenOption[0]);
            return Paths.convert((Path)pathToPOMXML);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public POM load(org.uberfire.backend.vfs.Path path) {
        try {
            POM pom = this.pomContentHandler.toModel(this.loadPomXMLString(path));
            return pom;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String loadPomXMLString(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        return this.ioService.readAllString(nioPath);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata, String comment) {
        try {
            if (metadata == null) {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), new OpenOption[0]);
            } else {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), this.metadataService.setUpAttributes(path, metadata), new OpenOption[0]);
            }
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata, String comment, boolean updateModules) {
        try {
            this.ioService.startBatch(new FileSystem[]{Paths.convert((org.uberfire.backend.vfs.Path)path).getFileSystem()}, new Option[]{this.optionsFactory.makeCommentedOption(comment != null ? comment : "")});
            ArrayList<Pair> modules = new ArrayList<Pair>();
            if (updateModules && content.isMultiModule() && content.getModules() != null) {
                Path rootPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
                rootPath = rootPath.getParent();
                for (String module : content.getModules()) {
                    POM child;
                    Path childPath = rootPath.resolve(module).resolve("pom.xml");
                    if (!this.ioService.exists(childPath) || (child = this.load(Paths.convert((Path)childPath))) == null) continue;
                    child.setParent(content.getGav());
                    child.getGav().setGroupId(content.getGav().getGroupId());
                    child.getGav().setVersion(content.getGav().getVersion());
                    modules.add(new Pair((Object)child, (Object)childPath));
                }
            }
            if (metadata == null) {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), new OpenOption[0]);
            } else {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), this.metadataService.setUpAttributes(path, metadata), new OpenOption[0]);
            }
            for (Pair modulePair : modules) {
                this.ioService.write((Path)modulePair.getK2(), this.pomContentHandler.toString((POM)modulePair.getK1(), this.loadPomXMLString(Paths.convert((Path)((Path)modulePair.getK2())))), new OpenOption[0]);
            }
            org.uberfire.backend.vfs.Path path2 = path;
            return path2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

