/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Model;
import org.guvnor.common.services.project.model.Dependency;

class DependencyUpdater {
    private Model model;

    DependencyUpdater(Model model) {
        this.model = model;
    }

    void updateDependencies(List<Dependency> dependencies) {
        this.removeAllThatDoNotExist(dependencies);
        this.addTheOnesThatDoNotExist(dependencies);
        this.updateTheRest(dependencies);
    }

    private void updateTheRest(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            for (org.apache.maven.model.Dependency modelDep : this.model.getDependencies()) {
                if (!this.hasSameID(dependency, modelDep)) continue;
                this.updateDependency(dependency, modelDep);
            }
        }
    }

    private void addTheOnesThatDoNotExist(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (this.depsContains(this.model.getDependencies(), dependency)) continue;
            this.model.addDependency(this.fromClientModelToPom(dependency));
        }
    }

    private void removeAllThatDoNotExist(List<Dependency> dependencies) {
        Iterator iterator = this.model.getDependencies().iterator();
        while (iterator.hasNext()) {
            org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)iterator.next();
            if (this.depsContains(dependencies, dependency)) continue;
            iterator.remove();
        }
    }

    private org.apache.maven.model.Dependency fromClientModelToPom(Dependency from) {
        org.apache.maven.model.Dependency dependency = this.updateDependency(from, new org.apache.maven.model.Dependency());
        return dependency;
    }

    private org.apache.maven.model.Dependency updateDependency(Dependency from, org.apache.maven.model.Dependency dependency) {
        dependency.setArtifactId(from.getArtifactId());
        dependency.setGroupId(from.getGroupId());
        dependency.setVersion(from.getVersion());
        dependency.setScope(from.getScope());
        return dependency;
    }

    private boolean depsContains(List<Dependency> dependencies, org.apache.maven.model.Dependency dependency) {
        for (Dependency modelDep : dependencies) {
            if (!this.hasSameID(modelDep, dependency)) continue;
            return true;
        }
        return false;
    }

    private boolean depsContains(List<org.apache.maven.model.Dependency> dependencies, Dependency dependency) {
        for (org.apache.maven.model.Dependency modelDep : dependencies) {
            if (!this.hasSameID(dependency, modelDep)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameID(Dependency dependency, org.apache.maven.model.Dependency modelDep) {
        return dependency.getArtifactId().equals(modelDep.getArtifactId()) && dependency.getGroupId().equals(modelDep.getGroupId());
    }
}

