/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.test;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.test.Failure;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class TestResultMessage {
    private boolean wasSuccessful;
    private int runCount;
    private int failureCount;
    private List<Failure> failures;

    public TestResultMessage() {
    }

    public TestResultMessage(boolean wasSuccessful, int runCount, int failureCount, List<Failure> failures) {
        this.wasSuccessful = wasSuccessful;
        this.runCount = runCount;
        this.failureCount = failureCount;
        this.failures = failures;
    }

    public boolean wasSuccessful() {
        return this.wasSuccessful;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public List<String> getResultStrings() {
        ArrayList<String> result = new ArrayList<String>(3 + (this.failures == null ? 0 : this.failures.size()));
        result.add("wasSuccessful: " + this.wasSuccessful);
        result.add("RunCount: " + this.runCount);
        result.add("FailureCount: " + this.failureCount);
        if (this.failures != null) {
            for (Failure failure : this.failures) {
                result.add("Failure: " + failure.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return "TestResultMessage{wasSuccessful=" + this.wasSuccessful + ", runCount=" + this.runCount + ", failureCount=" + this.failureCount + ", failures=" + this.failures + '}';
    }
}

