/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.metadata.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.commons.validation.PortablePreconditions;

@Portable
public class CategoryItem {
    private CategoryItem parent;
    private List<CategoryItem> children = new ArrayList<CategoryItem>();
    private String name;
    private String description;

    public CategoryItem() {
    }

    public CategoryItem(String name, String description, CategoryItem parent) {
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.description = description;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CategoryItem getParent() {
        return this.parent;
    }

    public List<CategoryItem> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void removeChildren(String name) {
        for (int i = 0; i < this.children.size(); ++i) {
            CategoryItem child = this.children.get(i);
            if (!child.getName().equals(name)) continue;
            this.children.remove(i);
            break;
        }
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    public CategoryItem addChildren(String name, String description) {
        CategoryItem newCategory = new CategoryItem(name, description, this);
        this.children.add(newCategory);
        return newCategory;
    }

    public boolean contains(String name) {
        for (CategoryItem child : this.children) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullPath() {
        if (this.getName() == null) {
            return "";
        }
        if (this.getParent() == null) {
            return this.getName();
        }
        String parent = this.getParent().getFullPath();
        if (parent.equals("")) {
            return this.getName();
        }
        return parent + "/" + this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryItem that = (CategoryItem)o;
        if (this.children != null ? !this.children.equals(that.children) : that.children != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(that.parent) : that.parent != null);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

