/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.security.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.guvnor.common.services.shared.security.KieWorkbenchFeature;

public class KieWorkbenchFeatureImpl
implements KieWorkbenchFeature {
    protected String id;
    protected String description;
    protected List<KieWorkbenchFeature> children = new ArrayList<KieWorkbenchFeature>();

    public KieWorkbenchFeatureImpl() {
    }

    public KieWorkbenchFeatureImpl(String id, String description) {
        this();
        this.id = id;
        this.description = description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<KieWorkbenchFeature> getChildren() {
        return this.children;
    }

    @Override
    public void addChildren(KieWorkbenchFeature f) {
        this.children.add(f);
    }

    @Override
    public void removeChildren(KieWorkbenchFeature feature) {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        Iterator<KieWorkbenchFeature> it = this.children.iterator();
        while (it.hasNext()) {
            KieWorkbenchFeature f = it.next();
            if (f.equals(feature)) {
                it.remove();
            }
            f.removeChildren(feature);
        }
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KieWorkbenchFeatureImpl that = (KieWorkbenchFeatureImpl)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "KieWorkbenchFeatureImpl{id='" + this.id + '\'' + ", description='" + this.description + '\'' + '}';
    }

    @Override
    public boolean implies(KieWorkbenchFeature feature) {
        if (this.equals(feature)) {
            return true;
        }
        if (this.getChildren() == null) {
            return false;
        }
        for (KieWorkbenchFeature child : this.getChildren()) {
            if (!child.implies(feature)) continue;
            return true;
        }
        return false;
    }
}

