/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.archive;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class Archiver {
    private Path originalPath;
    private ZipOutputStream outputStream;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public void archive(ByteArrayOutputStream outputStream, String uri) throws IOException, URISyntaxException {
        this.init(outputStream, uri);
        this.zip();
    }

    private void zip() throws IOException {
        if (Files.isDirectory((Path)this.originalPath, (LinkOption[])new LinkOption[0])) {
            this.addPath((DirectoryStream<Path>)Files.newDirectoryStream((Path)this.originalPath));
        } else {
            this.addFile(this.originalPath);
        }
        this.outputStream.close();
    }

    private void init(ByteArrayOutputStream outputStream, String uri) throws URISyntaxException {
        this.originalPath = this.ioService.get(new URI(uri));
        this.outputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
    }

    private void addPath(DirectoryStream<Path> directoryStream) throws IOException {
        for (Path subPath : directoryStream) {
            if (Files.isDirectory((Path)subPath, (LinkOption[])new LinkOption[0])) {
                this.addPath((DirectoryStream<Path>)Files.newDirectoryStream((Path)subPath));
                continue;
            }
            this.addFile(subPath);
        }
    }

    private void addFile(Path subPath) throws IOException {
        int count;
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        BufferedInputStream origin = new BufferedInputStream(this.ioService.newInputStream(subPath, new OpenOption[0]), 2048);
        this.outputStream.putNextEntry(this.getZipEntry(subPath));
        while ((count = origin.read(data, 0, 2048)) != -1) {
            this.outputStream.write(data, 0, count);
        }
        this.outputStream.flush();
        origin.close();
    }

    private ZipEntry getZipEntry(Path subPath) {
        String fileName = subPath.toUri().getPath().substring(this.originalPath.toUri().getPath().length() + 1);
        return new ZipEntry(fileName);
    }
}

