/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.uberfire.commons.validation.Preconditions;

@ApplicationScoped
public class RepositoryFactoryImpl
implements RepositoryFactory {
    @Inject
    private PasswordService secureService;
    @Inject
    @Any
    private Instance<RepositoryFactoryHelper> helpers;

    public Repository newRepository(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        Repository repository = null;
        for (RepositoryFactoryHelper helper : this.helpers) {
            if (!helper.accept(repoConfig)) continue;
            repository = helper.newRepository(repoConfig);
            break;
        }
        if (repository == null) {
            throw new IllegalArgumentException("Unrecognized scheme '" + (String)schemeConfigItem.getValue() + "'.");
        }
        ConfigItem roles = repoConfig.getConfigItem("security:roles");
        if (roles != null) {
            for (String role : (List)roles.getValue()) {
                repository.getRoles().add(role);
            }
        }
        return repository;
    }

    @Produces
    @Named(value="system")
    public Repository systemRepository() {
        return SystemRepository.SYSTEM_REPO;
    }
}

