/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfiguredRepositoriesTest {
    @Mock
    ConfigurationService configurationService;
    @Mock
    RepositoryFactory repositoryFactory;
    private ConfiguredRepositories configuredRepositories;

    @Before
    public void setUp() throws Exception {
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        configGroups.add(this.addRepository("single", "master"));
        configGroups.add(this.addRepository("multibranch", "master", "dev", "release"));
        Mockito.when((Object)this.configurationService.getConfiguration(ConfigType.REPOSITORY)).thenReturn(configGroups);
        this.configuredRepositories = new ConfiguredRepositories(this.configurationService, this.repositoryFactory, (Repository)SystemRepository.SYSTEM_REPO);
        this.configuredRepositories.loadRepositories();
    }

    private ConfigGroup addRepository(String alias, String ... branches) {
        ConfigGroup configGroup = new ConfigGroup();
        GitRepository repository = new GitRepository(alias);
        HashMap<String, Object> branchMap = new HashMap<String, Object>();
        for (String branch : branches) {
            branchMap.put(branch, Mockito.mock(Path.class));
        }
        repository.setBranches(branchMap);
        repository.setRoot((Path)branchMap.get("master"));
        Mockito.when((Object)this.repositoryFactory.newRepository(configGroup)).thenReturn((Object)repository);
        return configGroup;
    }

    @Test
    public void testLoadRepositories() throws Exception {
        Assert.assertEquals((long)2L, (long)this.configuredRepositories.getAllConfiguredRepositories().size());
    }

    @Test
    public void testLoadSingle() throws Exception {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias("single");
        Assert.assertEquals((long)1L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranchRoot("master"));
    }

    @Test
    public void testLoadMultiBranch() throws Exception {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias("multibranch");
        Assert.assertEquals((long)3L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranchRoot("master"));
        Assert.assertNotNull((Object)single.getBranchRoot("dev"));
        Assert.assertNotNull((Object)single.getBranchRoot("release"));
    }

    @Test
    public void testRemoveSingle() throws Exception {
        Path root = this.configuredRepositories.getRepositoryByRepositoryAlias("single").getRoot();
        Assert.assertNotNull((Object)this.configuredRepositories.getRepositoryByRootPath(root));
        Assert.assertNotNull((Object)this.configuredRepositories.remove("single"));
        Assert.assertFalse((boolean)this.configuredRepositories.containsAlias("single"));
        Assert.assertNull((Object)this.configuredRepositories.getRepositoryByRootPath(root));
    }

    @Test
    public void testRemoveMultiBranch() throws Exception {
        Path devRoot = this.configuredRepositories.getRepositoryByRepositoryAlias("multibranch").getBranchRoot("dev");
        Assert.assertNotNull((Object)this.configuredRepositories.getRepositoryByRootPath(devRoot));
        Assert.assertNotNull((Object)this.configuredRepositories.remove("multibranch"));
        Assert.assertFalse((boolean)this.configuredRepositories.containsAlias("multibranch"));
        Assert.assertNull((Object)this.configuredRepositories.getRepositoryByRootPath(devRoot));
    }

    @Test
    public void testNewBranch() throws Exception {
        Path branchPath = (Path)Mockito.mock(Path.class);
        NewBranchEvent changedEvent = new NewBranchEvent("single", "mybranch", branchPath, Long.valueOf(System.currentTimeMillis()));
        this.configuredRepositories.onNewBranch(changedEvent);
        Assert.assertEquals((Object)this.configuredRepositories.getRepositoryByRepositoryAlias("single").getRoot(), (Object)this.configuredRepositories.getRepositoryByRootPath(branchPath).getRoot());
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias("single");
        Assert.assertEquals((long)2L, (long)single.getBranches().size());
        Assert.assertEquals((Object)branchPath, (Object)single.getBranchRoot("mybranch"));
    }
}

