/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.clone;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.PasswordTextBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.util.URIUtil;

@Dependent
public class CloneRepositoryForm
extends PopupPanel {
    private static CloneRepositoryFormBinder uiBinder = (CloneRepositoryFormBinder)GWT.create(CloneRepositoryFormBinder.class);
    @Inject
    private Caller<RepositoryService> repositoryService;
    @Inject
    private Caller<OrganizationalUnitService> organizationalUnitService;
    @Inject
    private PlaceManager placeManager;
    @UiField
    Button clone;
    @UiField
    Button cancel;
    @UiField
    ControlGroup organizationalUnitGroup;
    @UiField
    ListBox organizationalUnitDropdown;
    @UiField
    HelpInline organizationalUnitHelpInline;
    @UiField
    ControlGroup nameGroup;
    @UiField
    TextBox nameTextBox;
    @UiField
    HelpInline nameHelpInline;
    @UiField
    ControlGroup urlGroup;
    @UiField
    TextBox gitURLTextBox;
    @UiField
    HelpInline urlHelpInline;
    @UiField
    TextBox usernameTextBox;
    @UiField
    PasswordTextBox passwordTextBox;
    @UiField
    BaseModal popup;
    @UiField
    InlineHTML isOUMandatory;
    private Map<String, OrganizationalUnit> availableOrganizationalUnits = new HashMap<String, OrganizationalUnit>();
    private boolean mandatoryOU = true;

    @PostConstruct
    public void init() {
        this.mandatoryOU = this.isOUMandatory();
        this.setWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (!this.mandatoryOU) {
            this.isOUMandatory.removeFromParent();
        }
        this.popup.setDynamicSafe(true);
        this.nameTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CloneRepositoryForm.this.nameGroup.setType(ControlGroupType.NONE);
                CloneRepositoryForm.this.nameHelpInline.setText("");
            }
        });
        this.gitURLTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CloneRepositoryForm.this.urlGroup.setType(ControlGroupType.NONE);
                CloneRepositoryForm.this.urlHelpInline.setText("");
            }
        });
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                CloneRepositoryForm.this.organizationalUnitDropdown.addItem(CoreConstants.INSTANCE.SelectEntry());
                if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
                    for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                        CloneRepositoryForm.this.organizationalUnitDropdown.addItem(organizationalUnit.getName(), organizationalUnit.getName());
                        CloneRepositoryForm.this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
                    }
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.CantLoadOrganizationalUnits() + " \n" + throwable.getMessage()));
                return false;
            }
        })).getOrganizationalUnits();
    }

    private boolean isOUMandatory() {
        try {
            IOCBeanDef beanDef = IOC.getBeanManager().lookupBean(RepositoryPreferences.class, new Annotation[0]);
            return beanDef == null || ((RepositoryPreferences)beanDef.getInstance()).isOUMandatory();
        }
        catch (IOCResolutionException iOCResolutionException) {
            return true;
        }
    }

    @UiHandler(value={"clone"})
    public void onCloneClick(ClickEvent e) {
        if (this.gitURLTextBox.getText() == null || this.gitURLTextBox.getText().trim().isEmpty()) {
            this.urlGroup.setType(ControlGroupType.ERROR);
            this.urlHelpInline.setText(CoreConstants.INSTANCE.URLMandatory());
            return;
        }
        if (!URIUtil.isValid((String)this.gitURLTextBox.getText().trim())) {
            this.urlGroup.setType(ControlGroupType.ERROR);
            this.urlHelpInline.setText(CoreConstants.INSTANCE.InvalidUrlFormat());
            return;
        }
        this.urlGroup.setType(ControlGroupType.NONE);
        final String organizationalUnit = this.organizationalUnitDropdown.getValue(this.organizationalUnitDropdown.getSelectedIndex());
        if (this.mandatoryOU && !this.availableOrganizationalUnits.containsKey(organizationalUnit)) {
            this.organizationalUnitGroup.setType(ControlGroupType.ERROR);
            this.organizationalUnitHelpInline.setText(CoreConstants.INSTANCE.OrganizationalUnitMandatory());
            return;
        }
        this.organizationalUnitGroup.setType(ControlGroupType.NONE);
        if (this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty()) {
            this.nameGroup.setType(ControlGroupType.ERROR);
            this.nameHelpInline.setText(CoreConstants.INSTANCE.RepositoryNaneMandatory());
            return;
        }
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String normalizedName) {
                if (!CloneRepositoryForm.this.nameTextBox.getText().equals(normalizedName)) {
                    if (!Window.confirm((String)(CoreConstants.INSTANCE.RepositoryNameInvalid() + " \"" + normalizedName + "\". " + CoreConstants.INSTANCE.DoYouAgree()))) {
                        return;
                    }
                    CloneRepositoryForm.this.nameTextBox.setText(normalizedName);
                }
                CloneRepositoryForm.this.lockScreen();
                String scheme = "git";
                String alias = CloneRepositoryForm.this.nameTextBox.getText().trim();
                String origin = CloneRepositoryForm.this.gitURLTextBox.getText().trim();
                String username = CloneRepositoryForm.this.usernameTextBox.getText().trim();
                String password = CloneRepositoryForm.this.passwordTextBox.getText().trim();
                HashMap<String, String> env = new HashMap<String, String>(3);
                env.put("username", username);
                env.put("crypt:password", password);
                env.put("origin", origin);
                ((RepositoryService)CloneRepositoryForm.this.repositoryService.call((RemoteCallback)new RemoteCallback<Repository>(){

                    public void callback(Repository o) {
                        BusyPopup.close();
                        Window.alert((String)(CoreConstants.INSTANCE.RepoCloneSuccess() + "\n\n" + CommonConstants.INSTANCE.IndexClonedRepositoryWarning()));
                        CloneRepositoryForm.this.hide();
                        CloneRepositoryForm.this.placeManager.goTo(new DefaultPlaceRequest("RepositoryEditor").addParameter("alias", o.getAlias()));
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (RepositoryAlreadyExistsException ex) {
                            ErrorPopup.showMessage((String)CoreConstants.INSTANCE.RepoAlreadyExists());
                        }
                        catch (Throwable ex) {
                            ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.RepoCloneFail() + " \n" + throwable.getMessage()));
                        }
                        CloneRepositoryForm.this.unlockScreen();
                        return true;
                    }
                })).createRepository((OrganizationalUnit)CloneRepositoryForm.this.availableOrganizationalUnits.get(organizationalUnit), "git", alias, env);
            }
        })).normalizeRepositoryName(this.nameTextBox.getText());
    }

    private void lockScreen() {
        BusyPopup.showMessage((String)CoreConstants.INSTANCE.Cloning());
        this.popup.setCloseVisible(false);
        this.clone.setEnabled(false);
        this.cancel.setEnabled(false);
        this.passwordTextBox.setEnabled(false);
        this.usernameTextBox.setEnabled(false);
        this.gitURLTextBox.setEnabled(false);
        this.organizationalUnitDropdown.setEnabled(false);
        this.nameTextBox.setEnabled(false);
    }

    private void unlockScreen() {
        BusyPopup.close();
        this.popup.setCloseVisible(true);
        this.clone.setEnabled(true);
        this.cancel.setEnabled(true);
        this.passwordTextBox.setEnabled(true);
        this.usernameTextBox.setEnabled(true);
        this.gitURLTextBox.setEnabled(true);
        this.organizationalUnitDropdown.setEnabled(true);
        this.nameTextBox.setEnabled(true);
    }

    @UiHandler(value={"cancel"})
    public void onCancelClick(ClickEvent e) {
        this.hide();
    }

    public void hide() {
        BusyPopup.close();
        this.popup.hide();
        super.hide();
    }

    public void show() {
        this.popup.show();
    }

    static interface CloneRepositoryFormBinder
    extends UiBinder<Widget, CloneRepositoryForm> {
    }
}

