/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.edit;

import com.github.gwtbootstrap.client.ui.Button;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import org.guvnor.structure.client.editors.repository.edit.RepositoryEditorPresenter;
import org.guvnor.structure.client.navigator.CommitNavigator;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.repositories.PublicURI;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.ParameterizedCommand;

public class RepositoryEditorView
extends Composite
implements RequiresResize,
RepositoryEditorPresenter.View {
    private static RepositoryEditorViewBinder uiBinder = (RepositoryEditorViewBinder)GWT.create(RepositoryEditorViewBinder.class);
    @UiField
    public InlineHTML ownerReference;
    @UiField
    public InlineHTML repoName;
    @UiField
    public InlineHTML repoDesc;
    @UiField
    public InlineHTML gitDaemonURI;
    @UiField
    public Button myGitCopyButton;
    @UiField
    public FlowPanel linksPanel;
    @UiField
    public FlowPanel history;
    @UiField
    public Button loadMore;
    private CommitNavigator commitNavigator = null;
    private RepositoryEditorPresenter presenter;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(RepositoryEditorPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setRepositoryInfo(String repositoryName, String owner, List<PublicURI> publicURIs, String description, final List<VersionRecord> initialVersionList) {
        if (owner != null && !owner.isEmpty()) {
            this.ownerReference.setText(owner + " / ");
        }
        this.repoName.setText(repositoryName);
        this.repoDesc.setText(description);
        int count = 0;
        if (publicURIs.size() > 0) {
            this.linksPanel.add((Widget)new InlineHTML(){
                {
                    this.setText(CoreConstants.INSTANCE.AvailableProtocols());
                    this.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
                }
            });
        }
        for (final PublicURI publicURI : publicURIs) {
            if (count == 0) {
                this.gitDaemonURI.setText(publicURI.getURI());
            }
            String protocol = publicURI.getProtocol() == null ? "default" : publicURI.getProtocol();
            Anchor anchor = new Anchor(protocol);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryEditorView.this.gitDaemonURI.setText(publicURI.getURI());
                }
            });
            if (count != 0) {
                anchor.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
            }
            this.linksPanel.add((Widget)anchor);
            ++count;
        }
        if (initialVersionList != null && !initialVersionList.isEmpty()) {
            this.commitNavigator = new CommitNavigator(){
                {
                    this.setOnRevertCommand(new ParameterizedCommand<VersionRecord>(){

                        public void execute(VersionRecord record) {
                            BusyPopup.showMessage((String)CoreConstants.INSTANCE.Reverting());
                            RepositoryEditorView.this.presenter.revert(record);
                        }
                    });
                    this.loadContent(initialVersionList);
                }
            };
            this.history.add((Widget)this.commitNavigator);
        } else {
            this.history.setVisible(false);
        }
        this.loadMore.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (RepositoryEditorView.this.commitNavigator != null) {
                    RepositoryEditorView.this.presenter.getLoadMoreHistory(RepositoryEditorView.this.commitNavigator.getLastIndex());
                }
            }
        });
        String uriId = "uri-for-" + repositoryName;
        this.gitDaemonURI.getElement().setId(uriId);
        this.myGitCopyButton.getElement().setAttribute("data-clipboard-target", uriId);
        this.myGitCopyButton.getElement().setAttribute("data-clipboard-text", this.gitDaemonURI.getText());
        this.myGitCopyButton.getElement().setId("button-" + uriId);
        this.myGitCopyButton.getElement().setTitle(CommonConstants.INSTANCE.copyRepositoryUrl());
        RepositoryEditorView.glueCopy(this.myGitCopyButton.getElement());
    }

    @Override
    public void reloadHistory(List<VersionRecord> versionList) {
        this.commitNavigator.loadContent(versionList);
        BusyPopup.close();
    }

    @Override
    public void addHistory(List<VersionRecord> versionList) {
        if (this.commitNavigator != null) {
            if (!versionList.isEmpty()) {
                this.commitNavigator.addContent(versionList);
            } else {
                this.loadMore.setEnabled(false);
            }
        }
    }

    @Override
    public void clear() {
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.setPixelSize(width, height);
    }

    public static native void glueCopy(Element var0);

    static interface RepositoryEditorViewBinder
    extends UiBinder<Widget, RepositoryEditorView> {
    }
}

