/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.navigator;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.guvnor.structure.client.resources.NavigatorResources;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class CommitNavigator
extends Composite {
    private FlowPanel container = new FlowPanel();
    private FlexTable navigator = null;
    private int lastIndex;
    private ParameterizedCommand<VersionRecord> onRevertCommand = null;

    public CommitNavigator() {
        this.initWidget((Widget)this.container);
    }

    public void setOnRevertCommand(ParameterizedCommand<VersionRecord> command) {
        this.onRevertCommand = command;
    }

    public void loadContent(List<VersionRecord> versionRecords) {
        this.lastIndex = 0;
        this.container.clear();
        if (this.navigator != null) {
            this.navigator.clear();
        }
        this.navigator = new FlexTable();
        this.navigator.setStyleName(NavigatorResources.INSTANCE.css().navigator());
        this.setupContent(versionRecords);
    }

    public void addContent(List<VersionRecord> content) {
        int base = this.navigator.getRowCount();
        for (int i = 0; i < content.size(); ++i) {
            VersionRecord dataContent = content.get(i);
            this.createElement(base + i, dataContent);
        }
    }

    private void setupContent(List<VersionRecord> content) {
        this.addContent(content);
        this.container.add((Widget)this.navigator);
    }

    private void createElement(int row, final VersionRecord dataContent) {
        int col = 0;
        Element messageCol = DOM.createDiv();
        messageCol.addClassName(NavigatorResources.INSTANCE.css().navigatorMessage());
        Element message = DOM.createSpan();
        message.addClassName(NavigatorResources.INSTANCE.css().message());
        message.setInnerText(dataContent.comment());
        messageCol.appendChild((Node)message);
        Element metadata = DOM.createDiv();
        Element author = DOM.createSpan();
        author.addClassName(NavigatorResources.INSTANCE.css().author());
        author.setInnerText(dataContent.author() + " - ");
        metadata.appendChild((Node)author);
        Element date = DOM.createSpan();
        date.addClassName(NavigatorResources.INSTANCE.css().date());
        DateTimeFormat fmt = DateTimeFormat.getFormat((String)"yyyy-MM-dd h:mm a");
        date.setInnerText(fmt.format(dataContent.date()));
        metadata.appendChild((Node)date);
        messageCol.appendChild((Node)metadata);
        this.navigator.setWidget(row, col, new Widget((com.google.gwt.dom.client.Element)messageCol){
            final /* synthetic */ com.google.gwt.dom.client.Element val$messageCol;
            {
                this.val$messageCol = element;
                this.setElement(this.val$messageCol);
            }
        });
        if (this.onRevertCommand != null) {
            this.navigator.setWidget(row, ++col, (Widget)new Button(CoreConstants.INSTANCE.RevertToThis()){
                {
                    super(x0);
                    this.setType(ButtonType.DANGER);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)CommonConstants.INSTANCE.Warning(), (String)CoreConstants.INSTANCE.ConfirmStateRevert(), (Command)new Command(){

                                public void execute() {
                                    CommitNavigator.this.onRevertCommand.execute((Object)dataContent);
                                }
                            }, (Command)new Command(){

                                public void execute() {
                                }
                            }, null);
                            yesNoCancelPopup.setCloseVisible(false);
                            yesNoCancelPopup.show();
                        }
                    });
                }
            });
        }
        ++this.lastIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }
}

