/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.navigator;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.client.navigator.Breadcrumb;
import org.guvnor.structure.client.navigator.NavigatorOptions;
import org.guvnor.structure.client.resources.NavigatorResources;
import org.guvnor.structure.navigator.DataContent;
import org.guvnor.structure.navigator.FileNavigatorService;
import org.guvnor.structure.navigator.NavigatorContent;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
public class FileNavigator
extends Composite {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<FileNavigatorService> navigatorService;
    private FlowPanel container = new FlowPanel();
    private FlexTable navigator = null;
    private NavigatorOptions options = NavigatorOptions.DEFAULT;
    private boolean isListingRepos = false;
    private ParameterizedCommand<Path> fileActionCommand = null;

    public FileNavigator() {
        this.initWidget((Widget)this.container);
    }

    public void setOptions(NavigatorOptions options) {
        this.options = options;
    }

    public void setFileActionCommand(ParameterizedCommand<Path> fileActionCommand) {
        this.fileActionCommand = fileActionCommand;
    }

    public void loadContent(final Path path) {
        if (path == null && this.options.listRepositories()) {
            ((FileNavigatorService)this.navigatorService.call((RemoteCallback)new RemoteCallback<List<Repository>>(){

                public void callback(List<Repository> response) {
                    FileNavigator.this.container.clear();
                    FileNavigator.this.navigator = new FlexTable();
                    FileNavigator.this.navigator.setStyleName(NavigatorResources.INSTANCE.css().navigator());
                    FileNavigator.this.isListingRepos = true;
                    FileNavigator.this.setupContent(response);
                }
            })).listRepositories();
        } else if (path != null) {
            ((FileNavigatorService)this.navigatorService.call((RemoteCallback)new RemoteCallback<NavigatorContent>(){

                public void callback(NavigatorContent response) {
                    FileNavigator.this.container.clear();
                    FileNavigator.this.navigator = new FlexTable();
                    FileNavigator.this.navigator.setStyleName(NavigatorResources.INSTANCE.css().navigator());
                    FileNavigator.this.isListingRepos = false;
                    FileNavigator.this.setupBreadcrumb(response, path);
                    if (!path.equals(response.getRoot())) {
                        FileNavigator.this.setupUpFolder(response);
                    } else if (FileNavigator.this.options.listRepositories()) {
                        FileNavigator.this.setupUpFolder();
                    }
                    FileNavigator.this.setupContent(response);
                }
            })).listContent(path);
        }
    }

    public boolean isListingRepos() {
        return this.isListingRepos;
    }

    private void setupBreadcrumb(final NavigatorContent response, final Path path) {
        if (!this.options.showBreadcrumb()) {
            return;
        }
        ParameterizedCommand<Path> command = this.options.breadcrumbWithLink() ? new ParameterizedCommand<Path>(){

            public void execute(Path path) {
                FileNavigator.this.loadContent(path);
            }
        } : null;
        this.container.add((Widget)new Breadcrumb((ParameterizedCommand)command, null){
            {
                super((ParameterizedCommand<Path>)x0, (ParameterizedCommand<Path>)x1);
                this.build(response.getRepoName(), response.getRoot(), response.getBreadcrumbs(), path);
            }
        });
    }

    private void setupContent(NavigatorContent content) {
        int base = this.navigator.getRowCount();
        for (int i = 0; i < content.getContent().size(); ++i) {
            DataContent dataContent = (DataContent)content.getContent().get(i);
            if (dataContent.isDirectory() && this.options.showDirectories()) {
                this.createDirectory(base + i, dataContent);
                continue;
            }
            if (!this.options.showFiles()) continue;
            this.createFile(base + i, dataContent);
        }
        this.container.add((Widget)this.navigator);
    }

    private void setupContent(List<Repository> response) {
        for (int i = 0; i < response.size(); ++i) {
            final Repository repository = response.get(i);
            this.createElement(i, repository, IconType.BOOK, NavigatorResources.INSTANCE.css().navigatorFolderIcon(), new Command(){

                public void execute() {
                    FileNavigator.this.loadContent(repository.getRoot());
                }
            });
        }
        this.container.add((Widget)this.navigator);
    }

    private void setupUpFolder(NavigatorContent content) {
        if (this.options.allowUpLink()) {
            if (content.getBreadcrumbs().size() == 0) {
                this.createUpFolder(content.getRoot());
            } else {
                this.createUpFolder((Path)content.getBreadcrumbs().get(content.getBreadcrumbs().size() - 1));
            }
        }
    }

    private void setupUpFolder() {
        if (this.options.allowUpLink()) {
            this.createUpFolder(null);
        }
    }

    private void createFile(int row, final DataContent dataContent) {
        this.createElement(row, dataContent, IconType.FILE_ALT, NavigatorResources.INSTANCE.css().navigatoFileIcon(), new Command(){

            public void execute() {
                if (FileNavigator.this.fileActionCommand != null) {
                    FileNavigator.this.fileActionCommand.execute((Object)dataContent.getPath());
                } else {
                    FileNavigator.this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(dataContent.getPath()));
                }
            }
        });
    }

    private void createDirectory(int row, final DataContent dataContent) {
        this.createElement(row, dataContent, IconType.FOLDER_CLOSE, NavigatorResources.INSTANCE.css().navigatorFolderIcon(), new Command(){

            public void execute() {
                FileNavigator.this.loadContent(dataContent.getPath());
            }
        });
    }

    private void createUpFolder(final Path path) {
        int col = 0;
        this.navigator.setText(0, col, "");
        this.navigator.setWidget(0, ++col, (Widget)new Anchor(".."){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        FileNavigator.this.loadContent(path);
                    }
                });
            }
        });
        if (this.options.showItemAge()) {
            this.navigator.setText(0, ++col, "");
        }
        if (this.options.showItemMessage()) {
            this.navigator.setText(0, ++col, "");
        }
    }

    private void createElement(int row, DataContent dataContent, IconType iconType, final String style, final Command onClick) {
        int col = 0;
        this.navigator.setWidget(row, col, (Widget)new Icon(iconType){
            {
                super(x0);
                this.addStyleName(style);
            }
        });
        this.navigator.setWidget(row, ++col, (Widget)new Anchor(dataContent.getPath().getFileName()){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        onClick.execute();
                    }
                });
            }
        });
        if (this.options.showItemAge()) {
            this.navigator.setText(row, ++col, dataContent.getAge());
        }
        if (this.options.showItemMessage()) {
            com.google.gwt.user.client.Element messageCol = DOM.createSpan();
            messageCol.addClassName(NavigatorResources.INSTANCE.css().navigatorMessage());
            com.google.gwt.user.client.Element message = DOM.createSpan();
            message.addClassName(NavigatorResources.INSTANCE.css().message());
            message.setInnerText(dataContent.getLastMessage());
            messageCol.appendChild((Node)message);
            if (this.options.showItemLastUpdater()) {
                com.google.gwt.user.client.Element colOpen = DOM.createSpan();
                colOpen.addClassName(NavigatorResources.INSTANCE.css().message());
                colOpen.setInnerText(" [");
                messageCol.appendChild((Node)colOpen);
                Anchor commiterRef = new Anchor(dataContent.getLastCommiter());
                DOM.sinkEvents((Element)commiterRef.getElement(), (int)1);
                DOM.setEventListener((Element)commiterRef.getElement(), (EventListener)new EventListener(){

                    public void onBrowserEvent(Event event) {
                    }
                });
                messageCol.appendChild((Node)commiterRef.getElement());
                com.google.gwt.user.client.Element colClose = DOM.createSpan();
                colClose.addClassName(NavigatorResources.INSTANCE.css().message());
                colClose.setInnerText("]");
                messageCol.appendChild((Node)colClose);
            }
            this.navigator.setWidget(row, ++col, new Widget((Element)messageCol){
                final /* synthetic */ Element val$messageCol;
                {
                    this.val$messageCol = element;
                    this.setElement(this.val$messageCol);
                }
            });
        }
    }

    private void createElement(int row, Repository repository, IconType iconType, final String style, final Command onClick) {
        int col = 0;
        this.navigator.setWidget(row, col, (Widget)new Icon(iconType){
            {
                super(x0);
                this.addStyleName(style);
            }
        });
        this.navigator.setWidget(row, ++col, (Widget)new Anchor(repository.getAlias()){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        onClick.execute();
                    }
                });
            }
        });
    }
}

